package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Form}.
 * @see ImmutableForm
 * @see ImmutableFormMetadata
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersForm implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormTypeAdapter(gson);
    }
    if (MetadataTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new MetadataTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersForm(Form, Metadata)";
  }

  @org.immutables.value.Generated(from = "Form", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class FormTypeAdapter extends TypeAdapter<Form> {
    public final FormItem dataSecondaryTypeSample = null;
    public final Form.Metadata metadataTypeSample = null;
    public final Variable variablesTypeSample = null;
    public final Form namespacesSecondaryTypeSample = null;
    public final FormValueSet valueSetsTypeSample = null;
    private final TypeAdapter<FormItem> dataSecondaryTypeAdapter;
    private final TypeAdapter<Form.Metadata> metadataTypeAdapter;
    private final TypeAdapter<Variable> variablesTypeAdapter;
    private final TypeAdapter<Form> namespacesSecondaryTypeAdapter;
    private final TypeAdapter<FormValueSet> valueSetsTypeAdapter;

    FormTypeAdapter(Gson gson) {
      this.dataSecondaryTypeAdapter = gson.getAdapter( FormItem.class);
      this.metadataTypeAdapter = gson.getAdapter( Form.Metadata.class);
      this.variablesTypeAdapter = gson.getAdapter( Variable.class);
      this.namespacesSecondaryTypeAdapter = gson.getAdapter( Form.class);
      this.valueSetsTypeAdapter = gson.getAdapter( FormValueSet.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Form.class == type.getRawType()
          || ImmutableForm.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Form value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeForm(out, value);
      }
    }

    @Override
    public Form read(JsonReader in) throws IOException {
      return readForm(in);
    }

    private void writeForm(JsonWriter out, Form instance)
        throws IOException {
      out.beginObject();
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("_id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("_id");
        out.nullValue();
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        out.name("_rev");
        out.value(revValue);
      } else if (out.getSerializeNulls()) {
        out.name("_rev");
        out.nullValue();
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        out.name("name");
        out.value(nameValue);
      } else if (out.getSerializeNulls()) {
        out.name("name");
        out.nullValue();
      }
      Map<String, FormItem> dataMapping = instance.getData();
      if (!dataMapping.isEmpty()) {
        out.name("data");
        out.beginObject();
        for (Map.Entry<String, FormItem> e : dataMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          FormItem value = e.getValue();
          dataSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("data");
        out.beginObject();
        out.endObject();
      }
      Form.Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        out.name("metadata");
        metadataTypeAdapter.write(out, metadataValue);
      } else if (out.getSerializeNulls()) {
        out.name("metadata");
        out.nullValue();
      }
      List<Variable> variablesElements = instance.getVariables();
      if (!variablesElements.isEmpty()) {
        out.name("variables");
        out.beginArray();
        for (Variable e : variablesElements) {
          variablesTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("variables");
        out.beginArray();
        out.endArray();
      }
      Map<String, Form> namespacesMapping = instance.getNamespaces();
      if (!namespacesMapping.isEmpty()) {
        out.name("namespaces");
        out.beginObject();
        for (Map.Entry<String, Form> e : namespacesMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Form value = e.getValue();
          namespacesSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("namespaces");
        out.beginObject();
        out.endObject();
      }
      List<FormValueSet> valueSetsElements = instance.getValueSets();
      if (!valueSetsElements.isEmpty()) {
        out.name("valueSets");
        out.beginArray();
        for (FormValueSet e : valueSetsElements) {
          valueSetsTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("valueSets");
        out.beginArray();
        out.endArray();
      }
      Map<String, String> requiredErrorTextMapping = instance.getRequiredErrorText();
      if (!requiredErrorTextMapping.isEmpty()) {
        out.name("requiredErrorText");
        out.beginObject();
        for (Map.Entry<String, String> e : requiredErrorTextMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          String value = e.getValue();
          out.value(value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("requiredErrorText");
        out.beginObject();
        out.endObject();
      }
      out.endObject();
    }

    private  Form readForm(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableForm.Builder builder = ImmutableForm.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case '_':
        if ("_id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        if ("_rev".equals(attributeName)) {
          readInRev(in, builder);
          return;
        }
        break;
      case 'n':
        if ("name".equals(attributeName)) {
          readInName(in, builder);
          return;
        }
        if ("namespaces".equals(attributeName)) {
          readInNamespaces(in, builder);
          return;
        }
        break;
      case 'd':
        if ("data".equals(attributeName)) {
          readInData(in, builder);
          return;
        }
        break;
      case 'm':
        if ("metadata".equals(attributeName)) {
          readInMetadata(in, builder);
          return;
        }
        break;
      case 'v':
        if ("variables".equals(attributeName)) {
          readInVariables(in, builder);
          return;
        }
        if ("valueSets".equals(attributeName)) {
          readInValueSets(in, builder);
          return;
        }
        break;
      case 'r':
        if ("requiredErrorText".equals(attributeName)) {
          readInRequiredErrorText(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInRev(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.rev(in.nextString());
      }
    }

    private void readInName(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.name(in.nextString());
      }
    }

    private void readInData(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          FormItem value = dataSecondaryTypeAdapter.read(in);
          builder.putData(key, value);
        }
        in.endObject();
      }
    }

    private void readInMetadata(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Form.Metadata value = metadataTypeAdapter.read(in);
        builder.metadata(value);
      }
    }

    private void readInVariables(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          Variable value = variablesTypeAdapter.read(in);
          builder.addVariables(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Variable value = variablesTypeAdapter.read(in);
        builder.addVariables(value);
      }
    }

    private void readInNamespaces(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          Form value = namespacesSecondaryTypeAdapter.read(in);
          builder.putNamespaces(key, value);
        }
        in.endObject();
      }
    }

    private void readInValueSets(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          FormValueSet value = valueSetsTypeAdapter.read(in);
          builder.addValueSets(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        FormValueSet value = valueSetsTypeAdapter.read(in);
        builder.addValueSets(value);
      }
    }

    private void readInRequiredErrorText(JsonReader in, ImmutableForm.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putRequiredErrorText(key, value);
        }
        in.endObject();
      }
    }
  }

  @org.immutables.value.Generated(from = "Form.Metadata", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class MetadataTypeAdapter extends TypeAdapter<Form.Metadata> {
    public final Date createdTypeSample = null;
    public final Date lastSavedTypeSample = null;
    public final Boolean validTypeSample = null;
    public final Object additionalPropertiesSecondaryTypeSample = null;
    private final TypeAdapter<Date> createdTypeAdapter;
    private final TypeAdapter<Date> lastSavedTypeAdapter;
    private final TypeAdapter<Boolean> validTypeAdapter;
    private final TypeAdapter<Object> additionalPropertiesSecondaryTypeAdapter;

    MetadataTypeAdapter(Gson gson) {
      this.createdTypeAdapter = gson.getAdapter( Date.class);
      this.lastSavedTypeAdapter = gson.getAdapter( Date.class);
      this.validTypeAdapter = gson.getAdapter( Boolean.class);
      this.additionalPropertiesSecondaryTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Form.Metadata.class == type.getRawType()
          || ImmutableFormMetadata.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Form.Metadata value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeMetadata(out, value);
      }
    }

    @Override
    public Form.Metadata read(JsonReader in) throws IOException {
      return readMetadata(in);
    }

    private void writeMetadata(JsonWriter out, Form.Metadata instance)
        throws IOException {
      out.beginObject();
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        out.name("label");
        out.value(labelValue);
      } else if (out.getSerializeNulls()) {
        out.name("label");
        out.nullValue();
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        out.name("created");
        createdTypeAdapter.write(out, createdValue);
      } else if (out.getSerializeNulls()) {
        out.name("created");
        out.nullValue();
      }
      Date lastSavedValue = instance.getLastSaved();
      if (lastSavedValue != null) {
        out.name("lastSaved");
        lastSavedTypeAdapter.write(out, lastSavedValue);
      } else if (out.getSerializeNulls()) {
        out.name("lastSaved");
        out.nullValue();
      }
      Boolean validValue = instance.getValid();
      if (validValue != null) {
        out.name("valid");
        validTypeAdapter.write(out, validValue);
      } else if (out.getSerializeNulls()) {
        out.name("valid");
        out.nullValue();
      }
      String creatorValue = instance.getCreator();
      if (creatorValue != null) {
        out.name("creator");
        out.value(creatorValue);
      } else if (out.getSerializeNulls()) {
        out.name("creator");
        out.nullValue();
      }
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        out.name("tenantId");
        out.value(tenantIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("tenantId");
        out.nullValue();
      }
      String savedByValue = instance.getSavedBy();
      if (savedByValue != null) {
        out.name("savedBy");
        out.value(savedByValue);
      } else if (out.getSerializeNulls()) {
        out.name("savedBy");
        out.nullValue();
      }
      Set<String> labelsElements = instance.getLabels();
      if (!labelsElements.isEmpty()) {
        out.name("labels");
        out.beginArray();
        for (String e : labelsElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("labels");
        out.beginArray();
        out.endArray();
      }
      String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
      if (defaultSubmitUrlValue != null) {
        out.name("defaultSubmitUrl");
        out.value(defaultSubmitUrlValue);
      } else if (out.getSerializeNulls()) {
        out.name("defaultSubmitUrl");
        out.nullValue();
      }
      Set<String> languagesElements = instance.getLanguages();
      if (!languagesElements.isEmpty()) {
        out.name("languages");
        out.beginArray();
        for (String e : languagesElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("languages");
        out.beginArray();
        out.endArray();
      }
      Map<String, Object> additionalPropertiesMapping = instance.getAdditionalProperties();
      if (!additionalPropertiesMapping.isEmpty()) {
        out.name("additionalProperties");
        out.beginObject();
        for (Map.Entry<String, Object> e : additionalPropertiesMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Object value = e.getValue();
          additionalPropertiesSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("additionalProperties");
        out.beginObject();
        out.endObject();
      }
      out.endObject();
    }

    private  Form.Metadata readMetadata(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormMetadata.Builder builder = ImmutableFormMetadata.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'l':
        if ("label".equals(attributeName)) {
          readInLabel(in, builder);
          return;
        }
        if ("lastSaved".equals(attributeName)) {
          readInLastSaved(in, builder);
          return;
        }
        if ("labels".equals(attributeName)) {
          readInLabels(in, builder);
          return;
        }
        if ("languages".equals(attributeName)) {
          readInLanguages(in, builder);
          return;
        }
        break;
      case 'c':
        if ("created".equals(attributeName)) {
          readInCreated(in, builder);
          return;
        }
        if ("creator".equals(attributeName)) {
          readInCreator(in, builder);
          return;
        }
        break;
      case 'v':
        if ("valid".equals(attributeName)) {
          readInValid(in, builder);
          return;
        }
        break;
      case 't':
        if ("tenantId".equals(attributeName)) {
          readInTenantId(in, builder);
          return;
        }
        break;
      case 's':
        if ("savedBy".equals(attributeName)) {
          readInSavedBy(in, builder);
          return;
        }
        break;
      case 'd':
        if ("defaultSubmitUrl".equals(attributeName)) {
          readInDefaultSubmitUrl(in, builder);
          return;
        }
        break;
      case 'a':
        if ("additionalProperties".equals(attributeName)) {
          readInAdditionalProperties(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInLabel(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.label(in.nextString());
      }
    }

    private void readInCreated(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = createdTypeAdapter.read(in);
        builder.created(value);
      }
    }

    private void readInLastSaved(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = lastSavedTypeAdapter.read(in);
        builder.lastSaved(value);
      }
    }

    private void readInValid(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = validTypeAdapter.read(in);
        builder.valid(value);
      }
    }

    private void readInCreator(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.creator(in.nextString());
      }
    }

    private void readInTenantId(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.tenantId(in.nextString());
      }
    }

    private void readInSavedBy(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.savedBy(in.nextString());
      }
    }

    private void readInLabels(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addLabels(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addLabels(in.nextString());
      }
    }

    private void readInDefaultSubmitUrl(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.defaultSubmitUrl(in.nextString());
      }
    }

    private void readInLanguages(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addLanguages(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addLanguages(in.nextString());
      }
    }

    private void readInAdditionalProperties(JsonReader in, ImmutableFormMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          Object value = additionalPropertiesSecondaryTypeAdapter.read(in);
          builder.putAdditionalProperties(key, value);
        }
        in.endObject();
      }
    }
  }
}
