/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.rest.ImmutableResponse;
import io.dialob.api.rest.Response;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.rest", generator="Gsons")
public final class GsonAdaptersResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ResponseTypeAdapter.adapts(type)) {
            return new ResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersResponse(Response)";
    }

    @Generated(from="Response", generator="Gsons")
    private static class ResponseTypeAdapter
    extends TypeAdapter<Response> {
        public final Boolean okTypeSample = null;
        private final TypeAdapter<Boolean> okTypeAdapter;

        ResponseTypeAdapter(Gson gson) {
            this.okTypeAdapter = gson.getAdapter(Boolean.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Response.class == type.getRawType() || ImmutableResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, Response value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeResponse(out, value);
            }
        }

        public Response read(JsonReader in) throws IOException {
            return this.readResponse(in);
        }

        private void writeResponse(JsonWriter out, Response instance) throws IOException {
            out.beginObject();
            Boolean okValue = instance.getOk();
            if (okValue != null) {
                out.name("ok");
                this.okTypeAdapter.write(out, (Object)okValue);
            } else if (out.getSerializeNulls()) {
                out.name("ok");
                out.nullValue();
            }
            String errorValue = instance.getError();
            if (errorValue != null) {
                out.name("error");
                out.value(errorValue);
            } else if (out.getSerializeNulls()) {
                out.name("error");
                out.nullValue();
            }
            String reasonValue = instance.getReason();
            if (reasonValue != null) {
                out.name("reason");
                out.value(reasonValue);
            } else if (out.getSerializeNulls()) {
                out.name("reason");
                out.nullValue();
            }
            out.endObject();
        }

        private Response readResponse(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableResponse.Builder builder = ImmutableResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'o': {
                    if (!"ok".equals(attributeName)) break;
                    this.readInOk(in, builder);
                    return;
                }
                case 'e': {
                    if (!"error".equals(attributeName)) break;
                    this.readInError(in, builder);
                    return;
                }
                case 'r': {
                    if (!"reason".equals(attributeName)) break;
                    this.readInReason(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInOk(JsonReader in, ImmutableResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.okTypeAdapter.read(in);
                builder.ok(value);
            }
        }

        private void readInError(JsonReader in, ImmutableResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.error(in.nextString());
            }
        }

        private void readInReason(JsonReader in, ImmutableResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.reason(in.nextString());
            }
        }
    }
}

