/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.rest.ImmutableItems;
import io.dialob.api.rest.Items;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.rest", generator="Gsons")
public final class GsonAdaptersItems
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ItemsTypeAdapter.adapts(type)) {
            return new ItemsTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersItems(Items)";
    }

    @Generated(from="Items", generator="Gsons")
    private static class ItemsTypeAdapter
    extends TypeAdapter<Items> {
        ItemsTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Items.class == type.getRawType() || ImmutableItems.class == type.getRawType();
        }

        public void write(JsonWriter out, Items value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeItems(out, value);
            }
        }

        public Items read(JsonReader in) throws IOException {
            return this.readItems(in);
        }

        private void writeItems(JsonWriter out, Items instance) throws IOException {
            out.beginObject();
            out.name("activeItem");
            out.value(instance.getActiveItem());
            List<String> itemsElements = instance.getItems();
            out.name("items");
            out.beginArray();
            for (String e : itemsElements) {
                out.value(e);
            }
            out.endArray();
            List<String> availableItemsElements = instance.getAvailableItems();
            out.name("availableItems");
            out.beginArray();
            for (String e : availableItemsElements) {
                out.value(e);
            }
            out.endArray();
            out.endObject();
        }

        private Items readItems(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableItems.Builder builder = ImmutableItems.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableItems.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if ("activeItem".equals(attributeName)) {
                        this.readInActiveItem(in, builder);
                        return;
                    }
                    if (!"availableItems".equals(attributeName)) break;
                    this.readInAvailableItems(in, builder);
                    return;
                }
                case 'i': {
                    if (!"items".equals(attributeName)) break;
                    this.readInItems(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInActiveItem(JsonReader in, ImmutableItems.Builder builder) throws IOException {
            builder.activeItem(in.nextString());
        }

        private void readInItems(JsonReader in, ImmutableItems.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addItems(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addItems(in.nextString());
            }
        }

        private void readInAvailableItems(JsonReader in, ImmutableItems.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addAvailableItems(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addAvailableItems(in.nextString());
            }
        }
    }
}

