/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.api.validation.WithValidation;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.immutables.gson.Gson;
import org.immutables.value.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;

@JsonSerialize(as=ImmutableQuestionnaire.class)
@JsonDeserialize(as=ImmutableQuestionnaire.class)
@JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Value.Modifiable
@Value.Style(deepImmutablesDetection=true, validationMethod=Value.Style.ValidationMethod.NONE, jdkOnly=true)
@Gson.TypeAdapters(emptyAsNulls=true)
public interface Questionnaire
extends WithValidation<Questionnaire>,
Serializable {
    @JsonProperty(value="_id")
    @Id
    @Gson.Named(value="_id")
    public String getId();

    @JsonProperty(value="_rev")
    @Version
    @Gson.Named(value="_rev")
    public String getRev();

    @NotNull
    public List<Answer> getAnswers();

    @NotNull
    public List<ContextValue> getContext();

    public String getActiveItem();

    @NotNull
    public List<Error> getErrors();

    @NotNull
    public List<VariableValue> getVariableValues();

    @NotNull
    public List<ValueSet> getValueSets();

    @Valid
    @NotNull
    public Metadata getMetadata();

    @JsonSerialize(as=ImmutableQuestionnaireMetadata.class)
    @JsonDeserialize(as=ImmutableQuestionnaireMetadata.class)
    @JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
    @Value.Immutable
    @Value.Modifiable
    @Value.Style(typeImmutable="ImmutableQuestionnaire*", typeModifiable="ModifiableQuestionnaire*", validationMethod=Value.Style.ValidationMethod.NONE, jdkOnly=true)
    @Gson.TypeAdapters
    public static abstract class Metadata
    implements Serializable {
        @NotNull
        public abstract String getFormId();

        public abstract String getFormName();

        @NotNull
        @Value.Default
        public Status getStatus() {
            return Status.NEW;
        }

        public abstract String getFormRev();

        public abstract String getTenantId();

        public abstract Date getCreated();

        public abstract Date getLastAnswer();

        public abstract Date getOpened();

        public abstract Date getCompleted();

        public abstract String getLabel();

        public abstract String getSubmitUrl();

        public abstract Reason getReason();

        public abstract String getLanguage();

        public abstract String getOwner();

        public abstract String getCreator();

        @JsonInclude
        @JsonAnyGetter
        @Gson.Ignore
        public abstract Map<String, Object> getAdditionalProperties();

        public static enum Reason {
            SKIPPED,
            CANCELLED;

        }

        public static enum Status {
            NEW,
            OPEN,
            COMPLETED;

        }
    }
}

