/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.questionnaire.ImmutableVariableValue;
import io.dialob.api.questionnaire.VariableValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="VariableValue", generator="Modifiables")
@NotThreadSafe
public final class ModifiableVariableValue
implements VariableValue {
    private static final long INIT_BIT_ID = 1L;
    private long initBits = 1L;
    private String id;
    private Object value;

    private ModifiableVariableValue() {
    }

    public static ModifiableVariableValue create(String id, Object value) {
        return new ModifiableVariableValue().setId(id).setValue(value);
    }

    public static ModifiableVariableValue create() {
        return new ModifiableVariableValue();
    }

    @Override
    @JsonProperty(value="id")
    public final String getId() {
        if (!this.idIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public final Object getValue() {
        return this.value;
    }

    public ModifiableVariableValue clear() {
        this.initBits = 1L;
        this.id = null;
        this.value = null;
        return this;
    }

    public ModifiableVariableValue from(VariableValue instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableVariableValue) {
            this.from((ModifiableVariableValue)instance);
            return this;
        }
        this.setId(instance.getId());
        Object valueValue = instance.getValue();
        if (valueValue != null) {
            this.setValue(valueValue);
        }
        return this;
    }

    public ModifiableVariableValue from(ModifiableVariableValue instance) {
        Object valueValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.idIsSet()) {
            this.setId(instance.getId());
        }
        if ((valueValue = instance.getValue()) != null) {
            this.setValue(valueValue);
        }
        return this;
    }

    public ModifiableVariableValue setId(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableVariableValue setValue(Object value) {
        this.value = value;
        return this;
    }

    public final boolean idIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final ModifiableVariableValue unsetId() {
        this.initBits |= 1L;
        this.id = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.idIsSet()) {
            attributes.add("id");
        }
        return "VariableValue is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableVariableValue toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableVariableValue.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableVariableValue)) {
            return false;
        }
        ModifiableVariableValue other = (ModifiableVariableValue)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableVariableValue another) {
        return this.id.equals(another.id) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "ModifiableVariableValue{id=" + (this.idIsSet() ? this.getId() : "?") + ", value=" + this.getValue() + "}";
    }
}

