/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ModifiableAnswer;
import io.dialob.api.questionnaire.ModifiableContextValue;
import io.dialob.api.questionnaire.ModifiableError;
import io.dialob.api.questionnaire.ModifiableQuestionnaireMetadata;
import io.dialob.api.questionnaire.ModifiableVariableValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Questionnaire", generator="Modifiables")
@NotThreadSafe
public final class ModifiableQuestionnaire
implements Questionnaire {
    private String id;
    private String rev;
    private final ArrayList<Answer> answers = new ArrayList();
    private final ArrayList<ContextValue> context = new ArrayList();
    private String activeItem;
    private final ArrayList<Error> errors = new ArrayList();
    private final ArrayList<VariableValue> variableValues = new ArrayList();
    private final ArrayList<ValueSet> valueSets = new ArrayList();
    private ModifiableQuestionnaireMetadata metadata;

    private ModifiableQuestionnaire() {
    }

    public static ModifiableQuestionnaire create() {
        return new ModifiableQuestionnaire();
    }

    @Override
    @JsonProperty(value="_id")
    public final String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="_rev")
    public final String getRev() {
        return this.rev;
    }

    @Override
    @JsonProperty(value="answers")
    public final List<Answer> getAnswers() {
        return this.answers;
    }

    @Override
    @JsonProperty(value="context")
    public final List<ContextValue> getContext() {
        return this.context;
    }

    @Override
    @JsonProperty(value="activeItem")
    public final String getActiveItem() {
        return this.activeItem;
    }

    @Override
    @JsonProperty(value="errors")
    public final List<Error> getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="variableValues")
    public final List<VariableValue> getVariableValues() {
        return this.variableValues;
    }

    @Override
    @JsonProperty(value="valueSets")
    public final List<ValueSet> getValueSets() {
        return this.valueSets;
    }

    @Override
    @JsonProperty(value="metadata")
    public final ModifiableQuestionnaireMetadata getMetadata() {
        return this.metadata;
    }

    public ModifiableQuestionnaire clear() {
        this.id = null;
        this.rev = null;
        this.answers.clear();
        this.context.clear();
        this.activeItem = null;
        this.errors.clear();
        this.variableValues.clear();
        this.valueSets.clear();
        this.metadata = null;
        return this;
    }

    public ModifiableQuestionnaire from(Questionnaire instance) {
        String revValue;
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableQuestionnaire) {
            this.from((ModifiableQuestionnaire)instance);
            return this;
        }
        String idValue = instance.getId();
        if (idValue != null) {
            this.setId(idValue);
        }
        if ((revValue = instance.getRev()) != null) {
            this.setRev(revValue);
        }
        this.addAllAnswers(instance.getAnswers());
        this.addAllContext(instance.getContext());
        String activeItemValue = instance.getActiveItem();
        if (activeItemValue != null) {
            this.setActiveItem(activeItemValue);
        }
        this.addAllErrors(instance.getErrors());
        this.addAllVariableValues(instance.getVariableValues());
        this.addAllValueSets(instance.getValueSets());
        Questionnaire.Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
            this.setMetadata(metadataValue);
        }
        return this;
    }

    public ModifiableQuestionnaire from(ModifiableQuestionnaire instance) {
        String revValue;
        Objects.requireNonNull(instance, "instance");
        String idValue = instance.getId();
        if (idValue != null) {
            this.setId(idValue);
        }
        if ((revValue = instance.getRev()) != null) {
            this.setRev(revValue);
        }
        this.addAllAnswers(instance.getAnswers());
        this.addAllContext(instance.getContext());
        String activeItemValue = instance.getActiveItem();
        if (activeItemValue != null) {
            this.setActiveItem(activeItemValue);
        }
        this.addAllErrors(instance.getErrors());
        this.addAllVariableValues(instance.getVariableValues());
        this.addAllValueSets(instance.getValueSets());
        ModifiableQuestionnaireMetadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
            this.setMetadata(metadataValue);
        }
        return this;
    }

    public ModifiableQuestionnaire setId(String id) {
        this.id = id;
        return this;
    }

    public ModifiableQuestionnaire setRev(String rev) {
        this.rev = rev;
        return this;
    }

    public ModifiableQuestionnaire addAnswers(Answer element) {
        this.answers.add(element instanceof ModifiableAnswer ? element : ModifiableAnswer.create().from(element));
        return this;
    }

    public final ModifiableQuestionnaire addAnswers(Answer ... elements) {
        for (Answer e : elements) {
            this.addAnswers(e);
        }
        return this;
    }

    public ModifiableQuestionnaire setAnswers(Iterable<? extends Answer> elements) {
        this.answers.clear();
        this.addAllAnswers(elements);
        return this;
    }

    public ModifiableQuestionnaire addAllAnswers(Iterable<? extends Answer> elements) {
        for (Answer answer : elements) {
            this.addAnswers(answer);
        }
        return this;
    }

    public ModifiableQuestionnaire addContext(ContextValue element) {
        this.context.add(element instanceof ModifiableContextValue ? element : ModifiableContextValue.create().from(element));
        return this;
    }

    public final ModifiableQuestionnaire addContext(ContextValue ... elements) {
        for (ContextValue e : elements) {
            this.addContext(e);
        }
        return this;
    }

    public ModifiableQuestionnaire setContext(Iterable<? extends ContextValue> elements) {
        this.context.clear();
        this.addAllContext(elements);
        return this;
    }

    public ModifiableQuestionnaire addAllContext(Iterable<? extends ContextValue> elements) {
        for (ContextValue contextValue : elements) {
            this.addContext(contextValue);
        }
        return this;
    }

    public ModifiableQuestionnaire setActiveItem(String activeItem) {
        this.activeItem = activeItem;
        return this;
    }

    public ModifiableQuestionnaire addErrors(Error element) {
        this.errors.add(element instanceof ModifiableError ? element : ModifiableError.create().from(element));
        return this;
    }

    public final ModifiableQuestionnaire addErrors(Error ... elements) {
        for (Error e : elements) {
            this.addErrors(e);
        }
        return this;
    }

    public ModifiableQuestionnaire setErrors(Iterable<? extends Error> elements) {
        this.errors.clear();
        this.addAllErrors(elements);
        return this;
    }

    public ModifiableQuestionnaire addAllErrors(Iterable<? extends Error> elements) {
        for (Error error : elements) {
            this.addErrors(error);
        }
        return this;
    }

    public ModifiableQuestionnaire addVariableValues(VariableValue element) {
        this.variableValues.add(element instanceof ModifiableVariableValue ? element : ModifiableVariableValue.create().from(element));
        return this;
    }

    public final ModifiableQuestionnaire addVariableValues(VariableValue ... elements) {
        for (VariableValue e : elements) {
            this.addVariableValues(e);
        }
        return this;
    }

    public ModifiableQuestionnaire setVariableValues(Iterable<? extends VariableValue> elements) {
        this.variableValues.clear();
        this.addAllVariableValues(elements);
        return this;
    }

    public ModifiableQuestionnaire addAllVariableValues(Iterable<? extends VariableValue> elements) {
        for (VariableValue variableValue : elements) {
            this.addVariableValues(variableValue);
        }
        return this;
    }

    public ModifiableQuestionnaire addValueSets(ValueSet element) {
        this.valueSets.add(element);
        return this;
    }

    public final ModifiableQuestionnaire addValueSets(ValueSet ... elements) {
        for (ValueSet e : elements) {
            this.addValueSets(e);
        }
        return this;
    }

    public ModifiableQuestionnaire setValueSets(Iterable<? extends ValueSet> elements) {
        this.valueSets.clear();
        this.addAllValueSets(elements);
        return this;
    }

    public ModifiableQuestionnaire addAllValueSets(Iterable<? extends ValueSet> elements) {
        for (ValueSet valueSet : elements) {
            this.addValueSets(valueSet);
        }
        return this;
    }

    public ModifiableQuestionnaire setMetadata(Questionnaire.Metadata metadata) {
        this.metadata = metadata == null ? null : (metadata instanceof ModifiableQuestionnaireMetadata ? (ModifiableQuestionnaireMetadata)metadata : ModifiableQuestionnaireMetadata.create().from(metadata));
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableQuestionnaire toImmutable() {
        return ImmutableQuestionnaire.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableQuestionnaire)) {
            return false;
        }
        ModifiableQuestionnaire other = (ModifiableQuestionnaire)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableQuestionnaire another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.rev, another.rev) && this.answers.equals(another.answers) && this.context.equals(another.context) && Objects.equals(this.activeItem, another.activeItem) && this.errors.equals(another.errors) && this.variableValues.equals(another.variableValues) && this.valueSets.equals(another.valueSets) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.rev);
        h += (h << 5) + this.answers.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + Objects.hashCode(this.activeItem);
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + this.variableValues.hashCode();
        h += (h << 5) + this.valueSets.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "ModifiableQuestionnaire{id=" + this.getId() + ", rev=" + this.getRev() + ", answers=" + this.getAnswers() + ", context=" + this.getContext() + ", activeItem=" + this.getActiveItem() + ", errors=" + this.getErrors() + ", variableValues=" + this.getVariableValues() + ", valueSets=" + this.getValueSets() + ", metadata=" + this.getMetadata() + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

