/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.questionnaire.ImmutableVariableValue;
import io.dialob.api.questionnaire.VariableValue;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.questionnaire", generator="Gsons")
public final class GsonAdaptersVariableValue
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (VariableValueTypeAdapter.adapts(type)) {
            return new VariableValueTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersVariableValue(VariableValue)";
    }

    @Generated(from="VariableValue", generator="Gsons")
    private static class VariableValueTypeAdapter
    extends TypeAdapter<VariableValue> {
        public final Object valueTypeSample = null;
        private final TypeAdapter<Object> valueTypeAdapter;

        VariableValueTypeAdapter(Gson gson) {
            this.valueTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return VariableValue.class == type.getRawType() || ImmutableVariableValue.class == type.getRawType();
        }

        public void write(JsonWriter out, VariableValue value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeVariableValue(out, value);
            }
        }

        public VariableValue read(JsonReader in) throws IOException {
            return this.readVariableValue(in);
        }

        private void writeVariableValue(JsonWriter out, VariableValue instance) throws IOException {
            out.beginObject();
            out.name("id");
            out.value(instance.getId());
            Object valueValue = instance.getValue();
            if (valueValue != null) {
                out.name("value");
                this.valueTypeAdapter.write(out, valueValue);
            } else if (out.getSerializeNulls()) {
                out.name("value");
                out.nullValue();
            }
            out.endObject();
        }

        private VariableValue readVariableValue(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableVariableValue.Builder builder = ImmutableVariableValue.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableVariableValue.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'v': {
                    if (!"value".equals(attributeName)) break;
                    this.readInValue(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableVariableValue.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInValue(JsonReader in, ImmutableVariableValue.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.valueTypeAdapter.read(in);
                builder.value(value);
            }
        }
    }
}

