/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.questionnaire", generator="Gsons")
public final class GsonAdaptersQuestionnaire
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (QuestionnaireTypeAdapter.adapts(type)) {
            return new QuestionnaireTypeAdapter(gson);
        }
        if (MetadataTypeAdapter.adapts(type)) {
            return new MetadataTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersQuestionnaire(Questionnaire, Metadata)";
    }

    @Generated(from="Questionnaire.Metadata", generator="Gsons")
    private static class MetadataTypeAdapter
    extends TypeAdapter<Questionnaire.Metadata> {
        public final Questionnaire.Metadata.Status statusTypeSample = null;
        public final Date createdTypeSample = null;
        public final Date lastAnswerTypeSample = null;
        public final Date openedTypeSample = null;
        public final Date completedTypeSample = null;
        public final Questionnaire.Metadata.Reason reasonTypeSample = null;
        private final TypeAdapter<Questionnaire.Metadata.Status> statusTypeAdapter;
        private final TypeAdapter<Date> createdTypeAdapter;
        private final TypeAdapter<Date> lastAnswerTypeAdapter;
        private final TypeAdapter<Date> openedTypeAdapter;
        private final TypeAdapter<Date> completedTypeAdapter;
        private final TypeAdapter<Questionnaire.Metadata.Reason> reasonTypeAdapter;

        MetadataTypeAdapter(Gson gson) {
            this.statusTypeAdapter = gson.getAdapter(Questionnaire.Metadata.Status.class);
            this.createdTypeAdapter = gson.getAdapter(Date.class);
            this.lastAnswerTypeAdapter = gson.getAdapter(Date.class);
            this.openedTypeAdapter = gson.getAdapter(Date.class);
            this.completedTypeAdapter = gson.getAdapter(Date.class);
            this.reasonTypeAdapter = gson.getAdapter(Questionnaire.Metadata.Reason.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Questionnaire.Metadata.class == type.getRawType() || ImmutableQuestionnaireMetadata.class == type.getRawType();
        }

        public void write(JsonWriter out, Questionnaire.Metadata value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeMetadata(out, value);
            }
        }

        public Questionnaire.Metadata read(JsonReader in) throws IOException {
            return this.readMetadata(in);
        }

        private void writeMetadata(JsonWriter out, Questionnaire.Metadata instance) throws IOException {
            out.beginObject();
            String formIdValue = instance.getFormId();
            if (formIdValue != null) {
                out.name("formId");
                out.value(formIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("formId");
                out.nullValue();
            }
            String formNameValue = instance.getFormName();
            if (formNameValue != null) {
                out.name("formName");
                out.value(formNameValue);
            } else if (out.getSerializeNulls()) {
                out.name("formName");
                out.nullValue();
            }
            out.name("status");
            this.statusTypeAdapter.write(out, (Object)instance.getStatus());
            String formRevValue = instance.getFormRev();
            if (formRevValue != null) {
                out.name("formRev");
                out.value(formRevValue);
            } else if (out.getSerializeNulls()) {
                out.name("formRev");
                out.nullValue();
            }
            String tenantIdValue = instance.getTenantId();
            if (tenantIdValue != null) {
                out.name("tenantId");
                out.value(tenantIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("tenantId");
                out.nullValue();
            }
            Date createdValue = instance.getCreated();
            if (createdValue != null) {
                out.name("created");
                this.createdTypeAdapter.write(out, (Object)createdValue);
            } else if (out.getSerializeNulls()) {
                out.name("created");
                out.nullValue();
            }
            Date lastAnswerValue = instance.getLastAnswer();
            if (lastAnswerValue != null) {
                out.name("lastAnswer");
                this.lastAnswerTypeAdapter.write(out, (Object)lastAnswerValue);
            } else if (out.getSerializeNulls()) {
                out.name("lastAnswer");
                out.nullValue();
            }
            Date openedValue = instance.getOpened();
            if (openedValue != null) {
                out.name("opened");
                this.openedTypeAdapter.write(out, (Object)openedValue);
            } else if (out.getSerializeNulls()) {
                out.name("opened");
                out.nullValue();
            }
            Date completedValue = instance.getCompleted();
            if (completedValue != null) {
                out.name("completed");
                this.completedTypeAdapter.write(out, (Object)completedValue);
            } else if (out.getSerializeNulls()) {
                out.name("completed");
                out.nullValue();
            }
            String labelValue = instance.getLabel();
            if (labelValue != null) {
                out.name("label");
                out.value(labelValue);
            } else if (out.getSerializeNulls()) {
                out.name("label");
                out.nullValue();
            }
            String submitUrlValue = instance.getSubmitUrl();
            if (submitUrlValue != null) {
                out.name("submitUrl");
                out.value(submitUrlValue);
            } else if (out.getSerializeNulls()) {
                out.name("submitUrl");
                out.nullValue();
            }
            Questionnaire.Metadata.Reason reasonValue = instance.getReason();
            if (reasonValue != null) {
                out.name("reason");
                this.reasonTypeAdapter.write(out, (Object)reasonValue);
            } else if (out.getSerializeNulls()) {
                out.name("reason");
                out.nullValue();
            }
            String languageValue = instance.getLanguage();
            if (languageValue != null) {
                out.name("language");
                out.value(languageValue);
            } else if (out.getSerializeNulls()) {
                out.name("language");
                out.nullValue();
            }
            String ownerValue = instance.getOwner();
            if (ownerValue != null) {
                out.name("owner");
                out.value(ownerValue);
            } else if (out.getSerializeNulls()) {
                out.name("owner");
                out.nullValue();
            }
            String creatorValue = instance.getCreator();
            if (creatorValue != null) {
                out.name("creator");
                out.value(creatorValue);
            } else if (out.getSerializeNulls()) {
                out.name("creator");
                out.nullValue();
            }
            out.endObject();
        }

        private Questionnaire.Metadata readMetadata(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableQuestionnaireMetadata.Builder builder = ImmutableQuestionnaireMetadata.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'f': {
                    if ("formId".equals(attributeName)) {
                        this.readInFormId(in, builder);
                        return;
                    }
                    if ("formName".equals(attributeName)) {
                        this.readInFormName(in, builder);
                        return;
                    }
                    if (!"formRev".equals(attributeName)) break;
                    this.readInFormRev(in, builder);
                    return;
                }
                case 's': {
                    if ("status".equals(attributeName)) {
                        this.readInStatus(in, builder);
                        return;
                    }
                    if (!"submitUrl".equals(attributeName)) break;
                    this.readInSubmitUrl(in, builder);
                    return;
                }
                case 't': {
                    if (!"tenantId".equals(attributeName)) break;
                    this.readInTenantId(in, builder);
                    return;
                }
                case 'c': {
                    if ("created".equals(attributeName)) {
                        this.readInCreated(in, builder);
                        return;
                    }
                    if ("completed".equals(attributeName)) {
                        this.readInCompleted(in, builder);
                        return;
                    }
                    if (!"creator".equals(attributeName)) break;
                    this.readInCreator(in, builder);
                    return;
                }
                case 'l': {
                    if ("lastAnswer".equals(attributeName)) {
                        this.readInLastAnswer(in, builder);
                        return;
                    }
                    if ("label".equals(attributeName)) {
                        this.readInLabel(in, builder);
                        return;
                    }
                    if (!"language".equals(attributeName)) break;
                    this.readInLanguage(in, builder);
                    return;
                }
                case 'o': {
                    if ("opened".equals(attributeName)) {
                        this.readInOpened(in, builder);
                        return;
                    }
                    if (!"owner".equals(attributeName)) break;
                    this.readInOwner(in, builder);
                    return;
                }
                case 'r': {
                    if (!"reason".equals(attributeName)) break;
                    this.readInReason(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInFormId(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.formId(in.nextString());
            }
        }

        private void readInFormName(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.formName(in.nextString());
            }
        }

        private void readInStatus(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            Questionnaire.Metadata.Status value = (Questionnaire.Metadata.Status)((Object)this.statusTypeAdapter.read(in));
            builder.status(value);
        }

        private void readInFormRev(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.formRev(in.nextString());
            }
        }

        private void readInTenantId(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.tenantId(in.nextString());
            }
        }

        private void readInCreated(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.createdTypeAdapter.read(in);
                builder.created(value);
            }
        }

        private void readInLastAnswer(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.lastAnswerTypeAdapter.read(in);
                builder.lastAnswer(value);
            }
        }

        private void readInOpened(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.openedTypeAdapter.read(in);
                builder.opened(value);
            }
        }

        private void readInCompleted(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.completedTypeAdapter.read(in);
                builder.completed(value);
            }
        }

        private void readInLabel(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.label(in.nextString());
            }
        }

        private void readInSubmitUrl(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.submitUrl(in.nextString());
            }
        }

        private void readInReason(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Questionnaire.Metadata.Reason value = (Questionnaire.Metadata.Reason)((Object)this.reasonTypeAdapter.read(in));
                builder.reason(value);
            }
        }

        private void readInLanguage(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.language(in.nextString());
            }
        }

        private void readInOwner(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.owner(in.nextString());
            }
        }

        private void readInCreator(JsonReader in, ImmutableQuestionnaireMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.creator(in.nextString());
            }
        }
    }

    @Generated(from="Questionnaire", generator="Gsons")
    private static class QuestionnaireTypeAdapter
    extends TypeAdapter<Questionnaire> {
        public final Answer answersTypeSample = null;
        public final ContextValue contextTypeSample = null;
        public final Error errorsTypeSample = null;
        public final VariableValue variableValuesTypeSample = null;
        public final ValueSet valueSetsTypeSample = null;
        public final Questionnaire.Metadata metadataTypeSample = null;
        private final TypeAdapter<Answer> answersTypeAdapter;
        private final TypeAdapter<ContextValue> contextTypeAdapter;
        private final TypeAdapter<Error> errorsTypeAdapter;
        private final TypeAdapter<VariableValue> variableValuesTypeAdapter;
        private final TypeAdapter<ValueSet> valueSetsTypeAdapter;
        private final TypeAdapter<Questionnaire.Metadata> metadataTypeAdapter;

        QuestionnaireTypeAdapter(Gson gson) {
            this.answersTypeAdapter = gson.getAdapter(Answer.class);
            this.contextTypeAdapter = gson.getAdapter(ContextValue.class);
            this.errorsTypeAdapter = gson.getAdapter(Error.class);
            this.variableValuesTypeAdapter = gson.getAdapter(VariableValue.class);
            this.valueSetsTypeAdapter = gson.getAdapter(ValueSet.class);
            this.metadataTypeAdapter = gson.getAdapter(Questionnaire.Metadata.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Questionnaire.class == type.getRawType() || ImmutableQuestionnaire.class == type.getRawType();
        }

        public void write(JsonWriter out, Questionnaire value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeQuestionnaire(out, value);
            }
        }

        public Questionnaire read(JsonReader in) throws IOException {
            return this.readQuestionnaire(in);
        }

        private void writeQuestionnaire(JsonWriter out, Questionnaire instance) throws IOException {
            out.beginObject();
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("_id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("_id");
                out.nullValue();
            }
            String revValue = instance.getRev();
            if (revValue != null) {
                out.name("_rev");
                out.value(revValue);
            } else if (out.getSerializeNulls()) {
                out.name("_rev");
                out.nullValue();
            }
            List<Answer> answersElements = instance.getAnswers();
            if (!answersElements.isEmpty()) {
                out.name("answers");
                out.beginArray();
                for (Answer answer : answersElements) {
                    this.answersTypeAdapter.write(out, (Object)answer);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("answers");
                out.beginArray();
                out.endArray();
            }
            List<ContextValue> contextElements = instance.getContext();
            if (!contextElements.isEmpty()) {
                out.name("context");
                out.beginArray();
                for (ContextValue e : contextElements) {
                    this.contextTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("context");
                out.beginArray();
                out.endArray();
            }
            String string = instance.getActiveItem();
            if (string != null) {
                out.name("activeItem");
                out.value(string);
            } else if (out.getSerializeNulls()) {
                out.name("activeItem");
                out.nullValue();
            }
            List<Error> errorsElements = instance.getErrors();
            if (!errorsElements.isEmpty()) {
                out.name("errors");
                out.beginArray();
                for (Error error : errorsElements) {
                    this.errorsTypeAdapter.write(out, (Object)error);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("errors");
                out.beginArray();
                out.endArray();
            }
            List<VariableValue> variableValuesElements = instance.getVariableValues();
            if (!variableValuesElements.isEmpty()) {
                out.name("variableValues");
                out.beginArray();
                for (VariableValue variableValue : variableValuesElements) {
                    this.variableValuesTypeAdapter.write(out, (Object)variableValue);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("variableValues");
                out.beginArray();
                out.endArray();
            }
            List<ValueSet> list = instance.getValueSets();
            if (!list.isEmpty()) {
                out.name("valueSets");
                out.beginArray();
                for (ValueSet e : list) {
                    this.valueSetsTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("valueSets");
                out.beginArray();
                out.endArray();
            }
            Questionnaire.Metadata metadata = instance.getMetadata();
            if (metadata != null) {
                out.name("metadata");
                this.metadataTypeAdapter.write(out, (Object)metadata);
            } else if (out.getSerializeNulls()) {
                out.name("metadata");
                out.nullValue();
            }
            out.endObject();
        }

        private Questionnaire readQuestionnaire(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableQuestionnaire.Builder builder = ImmutableQuestionnaire.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if ("_id".equals(attributeName)) {
                        this.readInId(in, builder);
                        return;
                    }
                    if (!"_rev".equals(attributeName)) break;
                    this.readInRev(in, builder);
                    return;
                }
                case 'a': {
                    if ("answers".equals(attributeName)) {
                        this.readInAnswers(in, builder);
                        return;
                    }
                    if (!"activeItem".equals(attributeName)) break;
                    this.readInActiveItem(in, builder);
                    return;
                }
                case 'c': {
                    if (!"context".equals(attributeName)) break;
                    this.readInContext(in, builder);
                    return;
                }
                case 'e': {
                    if (!"errors".equals(attributeName)) break;
                    this.readInErrors(in, builder);
                    return;
                }
                case 'v': {
                    if ("variableValues".equals(attributeName)) {
                        this.readInVariableValues(in, builder);
                        return;
                    }
                    if (!"valueSets".equals(attributeName)) break;
                    this.readInValueSets(in, builder);
                    return;
                }
                case 'm': {
                    if (!"metadata".equals(attributeName)) break;
                    this.readInMetadata(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInRev(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.rev(in.nextString());
            }
        }

        private void readInAnswers(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Answer value = (Answer)this.answersTypeAdapter.read(in);
                    builder.addAnswers(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Answer value = (Answer)this.answersTypeAdapter.read(in);
                builder.addAnswers(value);
            }
        }

        private void readInContext(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    ContextValue value = (ContextValue)this.contextTypeAdapter.read(in);
                    builder.addContext(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ContextValue value = (ContextValue)this.contextTypeAdapter.read(in);
                builder.addContext(value);
            }
        }

        private void readInActiveItem(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.activeItem(in.nextString());
            }
        }

        private void readInErrors(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Error value = (Error)this.errorsTypeAdapter.read(in);
                    builder.addErrors(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Error value = (Error)this.errorsTypeAdapter.read(in);
                builder.addErrors(value);
            }
        }

        private void readInVariableValues(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    VariableValue value = (VariableValue)this.variableValuesTypeAdapter.read(in);
                    builder.addVariableValues(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                VariableValue value = (VariableValue)this.variableValuesTypeAdapter.read(in);
                builder.addVariableValues(value);
            }
        }

        private void readInValueSets(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    ValueSet value = (ValueSet)this.valueSetsTypeAdapter.read(in);
                    builder.addValueSets(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ValueSet value = (ValueSet)this.valueSetsTypeAdapter.read(in);
                builder.addValueSets(value);
            }
        }

        private void readInMetadata(JsonReader in, ImmutableQuestionnaire.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Questionnaire.Metadata value = (Questionnaire.Metadata)this.metadataTypeAdapter.read(in);
                builder.metadata(value);
            }
        }
    }
}

