/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ImmutableFormValueSetEntry;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.form", generator="Gsons")
public final class GsonAdaptersFormValueSetEntry
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (FormValueSetEntryTypeAdapter.adapts(type)) {
            return new FormValueSetEntryTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersFormValueSetEntry(FormValueSetEntry)";
    }

    @Generated(from="FormValueSetEntry", generator="Gsons")
    private static class FormValueSetEntryTypeAdapter
    extends TypeAdapter<FormValueSetEntry> {
        FormValueSetEntryTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return FormValueSetEntry.class == type.getRawType() || ImmutableFormValueSetEntry.class == type.getRawType();
        }

        public void write(JsonWriter out, FormValueSetEntry value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeFormValueSetEntry(out, value);
            }
        }

        public FormValueSetEntry read(JsonReader in) throws IOException {
            return this.readFormValueSetEntry(in);
        }

        private void writeFormValueSetEntry(JsonWriter out, FormValueSetEntry instance) throws IOException {
            out.beginObject();
            out.name("id");
            out.value(instance.getId());
            Map<String, String> labelMapping = instance.getLabel();
            if (!labelMapping.isEmpty()) {
                out.name("label");
                out.beginObject();
                for (Map.Entry<String, String> e : labelMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    String value = e.getValue();
                    out.value(value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("label");
                out.beginObject();
                out.endObject();
            }
            String whenValue = instance.getWhen();
            if (whenValue != null) {
                out.name("when");
                out.value(whenValue);
            } else if (out.getSerializeNulls()) {
                out.name("when");
                out.nullValue();
            }
            out.endObject();
        }

        private FormValueSetEntry readFormValueSetEntry(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableFormValueSetEntry.Builder builder = ImmutableFormValueSetEntry.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableFormValueSetEntry.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'l': {
                    if (!"label".equals(attributeName)) break;
                    this.readInLabel(in, builder);
                    return;
                }
                case 'w': {
                    if (!"when".equals(attributeName)) break;
                    this.readInWhen(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableFormValueSetEntry.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInLabel(JsonReader in, ImmutableFormValueSetEntry.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putLabel(key, value);
                }
                in.endObject();
            }
        }

        private void readInWhen(JsonReader in, ImmutableFormValueSetEntry.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.when(in.nextString());
            }
        }
    }
}

