package io.dialob.api.proto;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Actions}.
 * @see ImmutableActions
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.proto", generator = "Gsons")
public final class GsonAdaptersActions implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ActionsTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ActionsTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersActions(Actions)";
  }

  @org.immutables.value.Generated(from = "Actions", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class ActionsTypeAdapter extends TypeAdapter<Actions> {
    public final Action actionsTypeSample = null;
    private final TypeAdapter<Action> actionsTypeAdapter;

    ActionsTypeAdapter(Gson gson) {
      this.actionsTypeAdapter = gson.getAdapter( Action.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Actions.class == type.getRawType()
          || ImmutableActions.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Actions value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeActions(out, value);
      }
    }

    @Override
    public Actions read(JsonReader in) throws IOException {
      return readActions(in);
    }

    private void writeActions(JsonWriter out, Actions instance)
        throws IOException {
      out.beginObject();
      String revValue = instance.getRev();
      if (revValue != null) {
        out.name("rev");
        out.value(revValue);
      } else if (out.getSerializeNulls()) {
        out.name("rev");
        out.nullValue();
      }
      List<Action> actionsElements = instance.getActions();
      if (actionsElements != null && !actionsElements.isEmpty()) {
        out.name("actions");
        out.beginArray();
        for (Action e : actionsElements) {
          actionsTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("actions");
        if (actionsElements == null) {
          out.nullValue();
        } else {
          out.beginArray();
          out.endArray();
        }
      }
      out.endObject();
    }

    private  Actions readActions(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableActions.Builder builder = ImmutableActions.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableActions.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'r':
        if ("rev".equals(attributeName)) {
          readInRev(in, builder);
          return;
        }
        break;
      case 'a':
        if ("actions".equals(attributeName)) {
          readInActions(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInRev(JsonReader in, ImmutableActions.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.rev(in.nextString());
      }
    }

    private void readInActions(JsonReader in, ImmutableActions.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Action value = actionsTypeAdapter.read(in);
            builder.addActions(value);
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Action value = actionsTypeAdapter.read(in);
          builder.addActions(value);
          empty = false;
        }
        if (empty) {
          builder.addAllActions(Collections.<Action>emptyList());
        }
      }
    }
  }
}
