package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormValueSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormValueSet.builder()}.
 */
@Generated(from = "FormValueSet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormValueSet implements FormValueSet {
  private final String id;
  private final List<FormValueSetEntry> entries;
  private final Map<String, Object> additionalProperties;

  private ImmutableFormValueSet(
      String id,
      List<FormValueSetEntry> entries,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.entries = entries;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @JsonProperty("entries")
  @Override
  public List<FormValueSetEntry> getEntries() {
    return entries;
  }

  /**
   * @return The value of the {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @JsonAnyGetter
  @Override
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValueSet#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValueSet withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormValueSet(value, this.entries, this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormValueSet#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValueSet withEntries(FormValueSetEntry... elements) {
    List<FormValueSetEntry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormValueSet(this.id, newValue, this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormValueSet#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValueSet withEntries(Iterable<? extends FormValueSetEntry> elements) {
    if (this.entries == elements) return this;
    List<FormValueSetEntry> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableFormValueSet(this.id, newValue, this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormValueSet#getAdditionalProperties() additionalProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the additionalProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValueSet withAdditionalProperties(Map<String, ? extends Object> entries) {
    if (this.additionalProperties == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormValueSet(this.id, this.entries, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormValueSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormValueSet
        && equalTo((ImmutableFormValueSet) another);
  }

  private boolean equalTo(ImmutableFormValueSet another) {
    return Objects.equals(id, another.id)
        && entries.equals(another.entries)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code entries}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + entries.hashCode();
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormValueSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormValueSet{"
        + "id=" + id
        + ", entries=" + entries
        + ", additionalProperties=" + additionalProperties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormValueSet", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormValueSet {
    @Nullable String id;
    @Nullable List<FormValueSetEntry> entries = Collections.emptyList();
    final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("entries")
    public void setEntries(List<FormValueSetEntry> entries) {
      this.entries = entries;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<FormValueSetEntry> getEntries() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getAdditionalProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormValueSet fromJson(Json json) {
    ImmutableFormValueSet.Builder builder = ImmutableFormValueSet.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.entries != null) {
      builder.addAllEntries(json.entries);
    }
    if (json.additionalProperties != null) {
      builder.putAllAdditionalProperties(json.additionalProperties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormValueSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormValueSet instance
   */
  public static ImmutableFormValueSet copyOf(FormValueSet instance) {
    if (instance instanceof ImmutableFormValueSet) {
      return (ImmutableFormValueSet) instance;
    }
    return ImmutableFormValueSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormValueSet ImmutableFormValueSet}.
   * <pre>
   * ImmutableFormValueSet.builder()
   *    .id(String | null) // nullable {@link FormValueSet#getId() id}
   *    .addEntries|addAllEntries(io.dialob.api.form.FormValueSetEntry) // {@link FormValueSet#getEntries() entries} elements
   *    .putAdditionalProperties|putAllAdditionalProperties(String =&gt; Object) // {@link FormValueSet#getAdditionalProperties() additionalProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableFormValueSet builder
   */
  public static ImmutableFormValueSet.Builder builder() {
    return new ImmutableFormValueSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormValueSet ImmutableFormValueSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormValueSet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private List<FormValueSetEntry> entries = new ArrayList<FormValueSetEntry>();
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFormValueSet} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableFormValueSet instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      addAllEntries(instance.getEntries());
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormValueSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormValueSet instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFormValueSet) {
        return from((ModifiableFormValueSet) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      addAllEntries(instance.getEntries());
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link FormValueSet#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Adds one element to {@link FormValueSet#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(@Nullable FormValueSetEntry element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FormValueSet#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(FormValueSetEntry... elements) {
      for (FormValueSetEntry element : elements) {
        this.entries.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entries")
    public final Builder entries(Iterable<? extends FormValueSetEntry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link FormValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntries(Iterable<? extends FormValueSetEntry> elements) {
      for (FormValueSetEntry element : elements) {
        this.entries.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSet#getAdditionalProperties() additionalProperties} map.
     * @param key The key in the additionalProperties map
     * @param value The associated value in the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder putAdditionalProperties(@Nullable String key, @Nullable Object value) {
      this.additionalProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSet#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.additionalProperties.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSet#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("additionalProperties")
    @JsonInclude
    public final Builder additionalProperties(Map<String, ? extends Object> entries) {
      this.additionalProperties.clear();
      return putAllAdditionalProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormValueSet#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.additionalProperties.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormValueSet ImmutableFormValueSet}.
     * @return An immutable instance of FormValueSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormValueSet build() {
      return new ImmutableFormValueSet(
          id,
          createUnmodifiableList(true, entries),
          createUnmodifiableMap(false, false, additionalProperties));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
