package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Form.Metadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormMetadata.builder()}.
 */
@Generated(from = "Form.Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFormMetadata implements Form.Metadata {
  private final String label;
  private final @Nullable Date created;
  private final @Nullable Date lastSaved;
  private final @Nullable Boolean valid;
  private final @Nullable String creator;
  private final @Nullable String tenantId;
  private final @Nullable String savedBy;
  private final Set<String> labels;
  private final @Nullable String defaultSubmitUrl;
  private final Set<String> languages;
  private final Map<String, Object> additionalProperties;

  private ImmutableFormMetadata(
      String label,
      @Nullable Date created,
      @Nullable Date lastSaved,
      @Nullable Boolean valid,
      @Nullable String creator,
      @Nullable String tenantId,
      @Nullable String savedBy,
      Set<String> labels,
      @Nullable String defaultSubmitUrl,
      Set<String> languages,
      Map<String, Object> additionalProperties) {
    this.label = label;
    this.created = created;
    this.lastSaved = lastSaved;
    this.valid = valid;
    this.creator = creator;
    this.tenantId = tenantId;
    this.savedBy = savedBy;
    this.labels = labels;
    this.defaultSubmitUrl = defaultSubmitUrl;
    this.languages = languages;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code lastSaved} attribute
   */
  @JsonProperty("lastSaved")
  @Override
  public @Nullable Date getLastSaved() {
    return lastSaved;
  }

  /**
   * @return The value of the {@code valid} attribute
   */
  @JsonProperty("valid")
  @Override
  public @Nullable Boolean getValid() {
    return valid;
  }

  /**
   * @return The value of the {@code creator} attribute
   */
  @JsonProperty("creator")
  @Override
  public @Nullable String getCreator() {
    return creator;
  }

  /**
   * @return The value of the {@code tenantId} attribute
   */
  @JsonProperty("tenantId")
  @Override
  public @Nullable String getTenantId() {
    return tenantId;
  }

  /**
   * @return The value of the {@code savedBy} attribute
   */
  @JsonProperty("savedBy")
  @Override
  public @Nullable String getSavedBy() {
    return savedBy;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public Set<String> getLabels() {
    return labels;
  }

  /**
   * @return The value of the {@code defaultSubmitUrl} attribute
   */
  @JsonProperty("defaultSubmitUrl")
  @Override
  public @Nullable String getDefaultSubmitUrl() {
    return defaultSubmitUrl;
  }

  /**
   * @return The value of the {@code languages} attribute
   */
  @JsonProperty("languages")
  @Override
  public Set<String> getLanguages() {
    return languages;
  }

  /**
   * @return The value of the {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @JsonAnyGetter
  @Override
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withLabel(String value) {
    if (Objects.equals(this.label, value)) return this;
    return new ImmutableFormMetadata(
        value,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withCreated(@Nullable Date value) {
    if (this.created == value) return this;
    return new ImmutableFormMetadata(
        this.label,
        value,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getLastSaved() lastSaved} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastSaved (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withLastSaved(@Nullable Date value) {
    if (this.lastSaved == value) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        value,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getValid() valid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valid (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withValid(@Nullable Boolean value) {
    if (Objects.equals(this.valid, value)) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        value,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getCreator() creator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withCreator(@Nullable String value) {
    if (Objects.equals(this.creator, value)) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        value,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withTenantId(@Nullable String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        value,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getSavedBy() savedBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for savedBy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withSavedBy(@Nullable String value) {
    if (Objects.equals(this.savedBy, value)) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        value,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form.Metadata#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadata withLabels(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        newValue,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form.Metadata#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadata withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, false, false));
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        newValue,
        this.defaultSubmitUrl,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form.Metadata#getDefaultSubmitUrl() defaultSubmitUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultSubmitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormMetadata withDefaultSubmitUrl(@Nullable String value) {
    if (Objects.equals(this.defaultSubmitUrl, value)) return this;
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        value,
        this.languages,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form.Metadata#getLanguages() languages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadata withLanguages(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        newValue,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form.Metadata#getLanguages() languages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of languages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadata withLanguages(Iterable<String> elements) {
    if (this.languages == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, false, false));
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        newValue,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the additionalProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormMetadata withAdditionalProperties(Map<String, ? extends Object> entries) {
    if (this.additionalProperties == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormMetadata(
        this.label,
        this.created,
        this.lastSaved,
        this.valid,
        this.creator,
        this.tenantId,
        this.savedBy,
        this.labels,
        this.defaultSubmitUrl,
        this.languages,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormMetadata
        && equalTo((ImmutableFormMetadata) another);
  }

  private boolean equalTo(ImmutableFormMetadata another) {
    return Objects.equals(label, another.label)
        && Objects.equals(created, another.created)
        && Objects.equals(lastSaved, another.lastSaved)
        && Objects.equals(valid, another.valid)
        && Objects.equals(creator, another.creator)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(savedBy, another.savedBy)
        && labels.equals(another.labels)
        && Objects.equals(defaultSubmitUrl, another.defaultSubmitUrl)
        && languages.equals(another.languages)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code created}, {@code lastSaved}, {@code valid}, {@code creator}, {@code tenantId}, {@code savedBy}, {@code labels}, {@code defaultSubmitUrl}, {@code languages}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastSaved);
    h += (h << 5) + Objects.hashCode(valid);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(savedBy);
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + Objects.hashCode(defaultSubmitUrl);
    h += (h << 5) + languages.hashCode();
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "label=" + label
        + ", created=" + created
        + ", lastSaved=" + lastSaved
        + ", valid=" + valid
        + ", creator=" + creator
        + ", tenantId=" + tenantId
        + ", savedBy=" + savedBy
        + ", labels=" + labels
        + ", defaultSubmitUrl=" + defaultSubmitUrl
        + ", languages=" + languages
        + ", additionalProperties=" + additionalProperties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Form.Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Form.Metadata {
    @javax.annotation.Nullable String label;
    @javax.annotation.Nullable Date created;
    @javax.annotation.Nullable Date lastSaved;
    @javax.annotation.Nullable Boolean valid;
    @javax.annotation.Nullable String creator;
    @javax.annotation.Nullable String tenantId;
    @javax.annotation.Nullable String savedBy;
    @javax.annotation.Nullable Set<String> labels = Collections.emptySet();
    @javax.annotation.Nullable String defaultSubmitUrl;
    @javax.annotation.Nullable Set<String> languages = Collections.emptySet();
    final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty("label")
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable Date created) {
      this.created = created;
    }
    @JsonProperty("lastSaved")
    public void setLastSaved(@Nullable Date lastSaved) {
      this.lastSaved = lastSaved;
    }
    @JsonProperty("valid")
    public void setValid(@Nullable Boolean valid) {
      this.valid = valid;
    }
    @JsonProperty("creator")
    public void setCreator(@Nullable String creator) {
      this.creator = creator;
    }
    @JsonProperty("tenantId")
    public void setTenantId(@Nullable String tenantId) {
      this.tenantId = tenantId;
    }
    @JsonProperty("savedBy")
    public void setSavedBy(@Nullable String savedBy) {
      this.savedBy = savedBy;
    }
    @JsonProperty("labels")
    public void setLabels(Set<String> labels) {
      this.labels = labels;
    }
    @JsonProperty("defaultSubmitUrl")
    public void setDefaultSubmitUrl(@Nullable String defaultSubmitUrl) {
      this.defaultSubmitUrl = defaultSubmitUrl;
    }
    @JsonProperty("languages")
    public void setLanguages(Set<String> languages) {
      this.languages = languages;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Date getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Date getLastSaved() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getValid() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreator() { throw new UnsupportedOperationException(); }
    @Override
    public String getTenantId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSavedBy() { throw new UnsupportedOperationException(); }
    @Override
    public Set<String> getLabels() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefaultSubmitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Set<String> getLanguages() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getAdditionalProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormMetadata fromJson(Json json) {
    ImmutableFormMetadata.Builder builder = ImmutableFormMetadata.builder();
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastSaved != null) {
      builder.lastSaved(json.lastSaved);
    }
    if (json.valid != null) {
      builder.valid(json.valid);
    }
    if (json.creator != null) {
      builder.creator(json.creator);
    }
    if (json.tenantId != null) {
      builder.tenantId(json.tenantId);
    }
    if (json.savedBy != null) {
      builder.savedBy(json.savedBy);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    if (json.defaultSubmitUrl != null) {
      builder.defaultSubmitUrl(json.defaultSubmitUrl);
    }
    if (json.languages != null) {
      builder.addAllLanguages(json.languages);
    }
    if (json.additionalProperties != null) {
      builder.putAllAdditionalProperties(json.additionalProperties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Form.Metadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Metadata instance
   */
  public static ImmutableFormMetadata copyOf(Form.Metadata instance) {
    if (instance instanceof ImmutableFormMetadata) {
      return (ImmutableFormMetadata) instance;
    }
    return ImmutableFormMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormMetadata ImmutableFormMetadata}.
   * <pre>
   * ImmutableFormMetadata.builder()
   *    .label(String | null) // nullable {@link Form.Metadata#getLabel() label}
   *    .created(Date | null) // nullable {@link Form.Metadata#getCreated() created}
   *    .lastSaved(Date | null) // nullable {@link Form.Metadata#getLastSaved() lastSaved}
   *    .valid(Boolean | null) // nullable {@link Form.Metadata#getValid() valid}
   *    .creator(String | null) // nullable {@link Form.Metadata#getCreator() creator}
   *    .tenantId(String | null) // nullable {@link Form.Metadata#getTenantId() tenantId}
   *    .savedBy(String | null) // nullable {@link Form.Metadata#getSavedBy() savedBy}
   *    .addLabels|addAllLabels(String) // {@link Form.Metadata#getLabels() labels} elements
   *    .defaultSubmitUrl(String | null) // nullable {@link Form.Metadata#getDefaultSubmitUrl() defaultSubmitUrl}
   *    .addLanguages|addAllLanguages(String) // {@link Form.Metadata#getLanguages() languages} elements
   *    .putAdditionalProperties|putAllAdditionalProperties(String =&gt; Object) // {@link Form.Metadata#getAdditionalProperties() additionalProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableFormMetadata builder
   */
  public static ImmutableFormMetadata.Builder builder() {
    return new ImmutableFormMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormMetadata ImmutableFormMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Form.Metadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String label;
    private @javax.annotation.Nullable Date created;
    private @javax.annotation.Nullable Date lastSaved;
    private @javax.annotation.Nullable Boolean valid;
    private @javax.annotation.Nullable String creator;
    private @javax.annotation.Nullable String tenantId;
    private @javax.annotation.Nullable String savedBy;
    private List<String> labels = new ArrayList<String>();
    private @javax.annotation.Nullable String defaultSubmitUrl;
    private List<String> languages = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFormMetadata} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableFormMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      Date lastSavedValue = instance.getLastSaved();
      if (lastSavedValue != null) {
        lastSaved(lastSavedValue);
      }
      Boolean validValue = instance.getValid();
      if (validValue != null) {
        valid(validValue);
      }
      String creatorValue = instance.getCreator();
      if (creatorValue != null) {
        creator(creatorValue);
      }
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        tenantId(tenantIdValue);
      }
      String savedByValue = instance.getSavedBy();
      if (savedByValue != null) {
        savedBy(savedByValue);
      }
      addAllLabels(instance.getLabels());
      String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
      if (defaultSubmitUrlValue != null) {
        defaultSubmitUrl(defaultSubmitUrlValue);
      }
      addAllLanguages(instance.getLanguages());
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Form.Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFormMetadata) {
        return from((ModifiableFormMetadata) instance);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      Date lastSavedValue = instance.getLastSaved();
      if (lastSavedValue != null) {
        lastSaved(lastSavedValue);
      }
      Boolean validValue = instance.getValid();
      if (validValue != null) {
        valid(validValue);
      }
      String creatorValue = instance.getCreator();
      if (creatorValue != null) {
        creator(creatorValue);
      }
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        tenantId(tenantIdValue);
      }
      String savedByValue = instance.getSavedBy();
      if (savedByValue != null) {
        savedBy(savedByValue);
      }
      addAllLabels(instance.getLabels());
      String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
      if (defaultSubmitUrlValue != null) {
        defaultSubmitUrl(defaultSubmitUrlValue);
      }
      addAllLanguages(instance.getLanguages());
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = label;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable Date created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getLastSaved() lastSaved} attribute.
     * @param lastSaved The value for lastSaved (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastSaved")
    public final Builder lastSaved(@Nullable Date lastSaved) {
      this.lastSaved = lastSaved;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getValid() valid} attribute.
     * @param valid The value for valid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valid")
    public final Builder valid(@Nullable Boolean valid) {
      this.valid = valid;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getCreator() creator} attribute.
     * @param creator The value for creator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("creator")
    public final Builder creator(@Nullable String creator) {
      this.creator = creator;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenantId")
    public final Builder tenantId(@Nullable String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getSavedBy() savedBy} attribute.
     * @param savedBy The value for savedBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("savedBy")
    public final Builder savedBy(@Nullable String savedBy) {
      this.savedBy = savedBy;
      return this;
    }

    /**
     * Adds one element to {@link Form.Metadata#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabels(@javax.annotation.Nullable String element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Form.Metadata#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLabels(String... elements) {
      for (String element : elements) {
        this.labels.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Form.Metadata#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("labels")
    public final Builder labels(Iterable<String> elements) {
      this.labels.clear();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link Form.Metadata#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabels(Iterable<String> elements) {
      for (String element : elements) {
        this.labels.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Form.Metadata#getDefaultSubmitUrl() defaultSubmitUrl} attribute.
     * @param defaultSubmitUrl The value for defaultSubmitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultSubmitUrl")
    public final Builder defaultSubmitUrl(@Nullable String defaultSubmitUrl) {
      this.defaultSubmitUrl = defaultSubmitUrl;
      return this;
    }

    /**
     * Adds one element to {@link Form.Metadata#getLanguages() languages} set.
     * @param element A languages element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLanguages(@javax.annotation.Nullable String element) {
      this.languages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Form.Metadata#getLanguages() languages} set.
     * @param elements An array of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLanguages(String... elements) {
      for (String element : elements) {
        this.languages.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Form.Metadata#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("languages")
    public final Builder languages(Iterable<String> elements) {
      this.languages.clear();
      return addAllLanguages(elements);
    }

    /**
     * Adds elements to {@link Form.Metadata#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLanguages(Iterable<String> elements) {
      for (String element : elements) {
        this.languages.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map.
     * @param key The key in the additionalProperties map
     * @param value The associated value in the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder putAdditionalProperties(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      this.additionalProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.additionalProperties.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("additionalProperties")
    @JsonInclude
    public final Builder additionalProperties(Map<String, ? extends Object> entries) {
      this.additionalProperties.clear();
      return putAllAdditionalProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Form.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.additionalProperties.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormMetadata ImmutableFormMetadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormMetadata build() {
      return new ImmutableFormMetadata(
          label,
          created,
          lastSaved,
          valid,
          creator,
          tenantId,
          savedBy,
          createUnmodifiableSet(labels),
          defaultSubmitUrl,
          createUnmodifiableSet(languages),
          createUnmodifiableMap(false, false, additionalProperties));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
