package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormValueSetEntry}.
 * @see ImmutableFormValueSetEntry
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormValueSetEntry implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormValueSetEntryTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormValueSetEntryTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormValueSetEntry(FormValueSetEntry)";
  }

  @org.immutables.value.Generated(from = "FormValueSetEntry", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class FormValueSetEntryTypeAdapter extends TypeAdapter<FormValueSetEntry> {

    FormValueSetEntryTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormValueSetEntry.class == type.getRawType()
          || ImmutableFormValueSetEntry.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormValueSetEntry value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormValueSetEntry(out, value);
      }
    }

    @Override
    public FormValueSetEntry read(JsonReader in) throws IOException {
      return readFormValueSetEntry(in);
    }

    private void writeFormValueSetEntry(JsonWriter out, FormValueSetEntry instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      Map<String, String> labelMapping = instance.getLabel();
      if (!labelMapping.isEmpty()) {
        out.name("label");
        out.beginObject();
        for (Map.Entry<String, String> e : labelMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          String value = e.getValue();
          out.value(value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("label");
        out.beginObject();
        out.endObject();
      }
      String whenValue = instance.getWhen();
      if (whenValue != null) {
        out.name("when");
        out.value(whenValue);
      } else if (out.getSerializeNulls()) {
        out.name("when");
        out.nullValue();
      }
      out.endObject();
    }

    private  FormValueSetEntry readFormValueSetEntry(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormValueSetEntry.Builder builder = ImmutableFormValueSetEntry.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormValueSetEntry.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'l':
        if ("label".equals(attributeName)) {
          readInLabel(in, builder);
          return;
        }
        break;
      case 'w':
        if ("when".equals(attributeName)) {
          readInWhen(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableFormValueSetEntry.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInLabel(JsonReader in, ImmutableFormValueSetEntry.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putLabel(key, value);
        }
        in.endObject();
      }
    }

    private void readInWhen(JsonReader in, ImmutableFormValueSetEntry.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.when(in.nextString());
      }
    }
  }
}
