/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.client;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.dialob.api.client.okhttp.ApiClient;
import io.dialob.api.client.okhttp.EncodingUtils;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.QuestionnaireListItem;
import io.dialob.api.rest.IdAndRevision;
import io.dialob.api.rest.Items;
import io.dialob.api.rest.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DialobQuestionnaireServiceApi
extends ApiClient.Api {
    @RequestLine(value="DELETE /questionnaires/{questionnaireId}")
    @Headers(value={"Content-Type: application/json", "Accept: */*,*/*,*/*,*/*"})
    public Response deleteQuestionnaire(@Param(value="questionnaireId") String var1);

    @RequestLine(value="DELETE /questionnaires/{questionnaireId}/answers/{answerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Error> deleteQuestionnaireAnswer(@Param(value="answerId") String var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="DELETE /questionnaires/{questionnaireId}/items/{itemId}/rows/{rowId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<String> deleteQuestionnaireItemRow(@Param(value="itemId") String var1, @Param(value="questionnaireId") String var2, @Param(value="rowId") String var3);

    @RequestLine(value="GET /questionnaires/{questionnaireId}")
    @Headers(value={"Accept: application/json"})
    public Questionnaire getQuestionnaire(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/answers")
    @Headers(value={"Accept: application/json"})
    public List<Answer> getQuestionnaireAnswers(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/errors")
    @Headers(value={"Accept: application/json"})
    public List<Error> getQuestionnaireErrors(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/items/{itemId}")
    @Headers(value={"Accept: application/json"})
    public ActionItem getQuestionnaireItem(@Param(value="itemId") String var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/items/{itemId}/rows")
    @Headers(value={"Accept: application/json"})
    public List<String> getQuestionnaireItemRows(@Param(value="itemId") String var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/items")
    @Headers(value={"Accept: application/json"})
    public List<ActionItem> getQuestionnaireItems(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/pages")
    @Headers(value={"Accept: application/json"})
    public Items getQuestionnairePages(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/status")
    @Headers(value={"Accept: application/json"})
    public String getQuestionnaireStatus(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/valueSets/{valueSetId}")
    @Headers(value={"Accept: application/json"})
    public ValueSet getQuestionnaireValueSet(@Param(value="questionnaireId") String var1, @Param(value="valueSetId") String var2);

    @RequestLine(value="GET /questionnaires/{questionnaireId}/valueSets")
    @Headers(value={"Accept: application/json"})
    public List<ValueSet> getQuestionnaireValueSets(@Param(value="questionnaireId") String var1);

    @RequestLine(value="GET /questionnaires?formId={formId}&formName={formName}&formTag={formTag}&owner={owner}&status={status}")
    @Headers(value={"Accept: application/json"})
    public List<QuestionnaireListItem> getQuestionnaires(@Param(value="formId") String var1, @Param(value="formName") String var2, @Param(value="formTag") String var3, @Param(value="owner") String var4, @Param(value="status") String var5);

    @RequestLine(value="GET /questionnaires?formId={formId}&formName={formName}&formTag={formTag}&owner={owner}&status={status}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public List<QuestionnaireListItem> getQuestionnaires(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /questionnaires")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IdAndRevision postQuestionnaire(Questionnaire var1);

    @RequestLine(value="POST /questionnaires/{questionnaireId}/items/{itemId}/rows")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<String> postQuestionnaireItemRow(@Param(value="itemId") String var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="PUT /questionnaires/{questionnaireId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Questionnaire putQuestionnaire(Questionnaire var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="PUT /questionnaires/{questionnaireId}/answers/{answerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Error> putQuestionnaireAnswer(Object var1, @Param(value="answerId") String var2, @Param(value="questionnaireId") String var3);

    @RequestLine(value="POST /questionnaires/{questionnaireId}/answers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Error> putQuestionnaireAnswers(List<Answer> var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="PUT /questionnaires/{questionnaireId}/pages")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Items putQuestionnairePages(Items var1, @Param(value="questionnaireId") String var2);

    @RequestLine(value="PUT /questionnaires/{questionnaireId}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public String putQuestionnaireStatus(String var1, @Param(value="questionnaireId") String var2);

    public static class GetQuestionnairesQueryParams
    extends HashMap<String, Object> {
        public GetQuestionnairesQueryParams formId(String value) {
            this.put("formId", EncodingUtils.encode(value));
            return this;
        }

        public GetQuestionnairesQueryParams formName(String value) {
            this.put("formName", EncodingUtils.encode(value));
            return this;
        }

        public GetQuestionnairesQueryParams formTag(String value) {
            this.put("formTag", EncodingUtils.encode(value));
            return this;
        }

        public GetQuestionnairesQueryParams owner(String value) {
            this.put("owner", EncodingUtils.encode(value));
            return this;
        }

        public GetQuestionnairesQueryParams status(String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }
    }
}

