/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.client;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.dialob.api.client.okhttp.ApiClient;
import io.dialob.api.client.okhttp.EncodingUtils;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.api.form.FormTag;
import io.dialob.api.rest.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DialobFormServiceApi
extends ApiClient.Api {
    @RequestLine(value="DELETE /forms/{formId}")
    @Headers(value={"Content-Type: application/json", "Accept: */*,*/*,*/*,*/*"})
    public Response deleteForm(@Param(value="formId") String var1);

    @RequestLine(value="GET /forms/{formId}?rev={rev}")
    @Headers(value={"Accept: application/json"})
    public Form getForm(@Param(value="formId") String var1, @Param(value="rev") String var2);

    @RequestLine(value="GET /forms/{formId}?rev={rev}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Form getForm(@Param(value="formId") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /forms/{formId}/tags/{tagName}")
    @Headers(value={"Accept: application/json"})
    public FormTag getFormTag(@Param(value="formId") String var1, @Param(value="tagName") String var2);

    @RequestLine(value="GET /forms/{formId}/tags")
    @Headers(value={"Accept: application/json"})
    public List<FormTag> getFormTags(@Param(value="formId") String var1);

    @RequestLine(value="GET /tags?formId={formId}&formName={formName}&name={name}")
    @Headers(value={"Accept: application/json"})
    public List<FormTag> getTags(@Param(value="formId") String var1, @Param(value="formName") String var2, @Param(value="name") String var3);

    @RequestLine(value="GET /tags?formId={formId}&formName={formName}&name={name}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public List<FormTag> getTags(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /forms")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Form postForm(Form var1);

    @RequestLine(value="POST /forms/{formId}/tags?rev={rev}&snapshot={snapshot}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Response postFormTag(FormTag var1, @Param(value="formId") String var2, @Param(value="rev") String var3, @Param(value="snapshot") Boolean var4);

    @RequestLine(value="POST /forms/{formId}/tags?rev={rev}&snapshot={snapshot}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Response postFormTag(FormTag var1, @Param(value="formId") String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="PUT /forms/{formId}?force={force}&newId={newId}&oldId={oldId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public FormPutResponse putForm(Form var1, @Param(value="formId") String var2, @Param(value="force") Boolean var3, @Param(value="newId") String var4, @Param(value="oldId") String var5);

    @RequestLine(value="PUT /forms/{formId}?force={force}&newId={newId}&oldId={oldId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public FormPutResponse putForm(Form var1, @Param(value="formId") String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="PUT /forms/{formId}/tags/latest")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Response putFormTagLatest(FormTag var1, @Param(value="formId") String var2);

    public static class PutFormQueryParams
    extends HashMap<String, Object> {
        public PutFormQueryParams force(Boolean value) {
            this.put("force", EncodingUtils.encode(value));
            return this;
        }

        public PutFormQueryParams newId(String value) {
            this.put("newId", EncodingUtils.encode(value));
            return this;
        }

        public PutFormQueryParams oldId(String value) {
            this.put("oldId", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class PostFormTagQueryParams
    extends HashMap<String, Object> {
        public PostFormTagQueryParams rev(String value) {
            this.put("rev", EncodingUtils.encode(value));
            return this;
        }

        public PostFormTagQueryParams snapshot(Boolean value) {
            this.put("snapshot", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagsQueryParams
    extends HashMap<String, Object> {
        public GetTagsQueryParams formId(String value) {
            this.put("formId", EncodingUtils.encode(value));
            return this;
        }

        public GetTagsQueryParams formName(String value) {
            this.put("formName", EncodingUtils.encode(value));
            return this;
        }

        public GetTagsQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFormQueryParams
    extends HashMap<String, Object> {
        public GetFormQueryParams rev(String value) {
            this.put("rev", EncodingUtils.encode(value));
            return this;
        }
    }
}

