package io.dialob.api.client;

import io.dialob.api.client.okhttp.ApiClient;
import io.dialob.api.client.okhttp.EncodingUtils;

import io.dialob.api.proto.ActionItem;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.rest.Errors;
import io.dialob.api.rest.IdAndRevision;
import io.dialob.api.rest.Items;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.QuestionnaireListItem;
import io.dialob.api.rest.Response;
import io.dialob.api.proto.ValueSet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-03-15T08:57:32.972245Z[Etc/UTC]")public interface DialobQuestionnaireServiceApi extends ApiClient.Api {

  /**
   * deleteQuestionnaire
   * 
   * @param questionnaireId questionnaireId (required)
   * @return Response
   */
  @RequestLine("DELETE /questionnaires/{questionnaireId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*,*/*,*/*,*/*",
  })
  Response deleteQuestionnaire(@Param("questionnaireId") String questionnaireId);
  /**
   * deleteQuestionnaireAnswer
   * 
   * @param answerId answerId (required)
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;Error&gt;
   */
  @RequestLine("DELETE /questionnaires/{questionnaireId}/answers/{answerId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  List<Error> deleteQuestionnaireAnswer(@Param("answerId") String answerId, @Param("questionnaireId") String questionnaireId);
  /**
   * deleteQuestionnaireItemRow
   * 
   * @param itemId itemId (required)
   * @param questionnaireId questionnaireId (required)
   * @param rowId rowId (required)
   * @return List&lt;String&gt;
   */
  @RequestLine("DELETE /questionnaires/{questionnaireId}/items/{itemId}/rows/{rowId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  List<String> deleteQuestionnaireItemRow(@Param("itemId") String itemId, @Param("questionnaireId") String questionnaireId, @Param("rowId") String rowId);
  /**
   * getQuestionnaire
   * 
   * @param questionnaireId questionnaireId (required)
   * @return Questionnaire
   */
  @RequestLine("GET /questionnaires/{questionnaireId}")
  @Headers({
      "Accept: application/json",
  })
  Questionnaire getQuestionnaire(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireAnswers
   * 
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;Answer&gt;
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/answers")
  @Headers({
      "Accept: application/json",
  })
  List<Answer> getQuestionnaireAnswers(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireErrors
   * 
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;Error&gt;
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/errors")
  @Headers({
      "Accept: application/json",
  })
  List<Error> getQuestionnaireErrors(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireItem
   * 
   * @param itemId itemId (required)
   * @param questionnaireId questionnaireId (required)
   * @return ActionItem
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/items/{itemId}")
  @Headers({
      "Accept: application/json",
  })
  ActionItem getQuestionnaireItem(@Param("itemId") String itemId, @Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireItemRows
   * 
   * @param itemId itemId (required)
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;String&gt;
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/items/{itemId}/rows")
  @Headers({
      "Accept: application/json",
  })
  List<String> getQuestionnaireItemRows(@Param("itemId") String itemId, @Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireItems
   * 
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;ActionItem&gt;
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/items")
  @Headers({
      "Accept: application/json",
  })
  List<ActionItem> getQuestionnaireItems(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnairePages
   * 
   * @param questionnaireId questionnaireId (required)
   * @return Items
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/pages")
  @Headers({
      "Accept: application/json",
  })
  Items getQuestionnairePages(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireStatus
   * 
   * @param questionnaireId questionnaireId (required)
   * @return String
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/status")
  @Headers({
      "Accept: application/json",
  })
  String getQuestionnaireStatus(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaireValueSet
   * 
   * @param questionnaireId questionnaireId (required)
   * @param valueSetId valueSetId (required)
   * @return ValueSet
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/valueSets/{valueSetId}")
  @Headers({
      "Accept: application/json",
  })
  ValueSet getQuestionnaireValueSet(@Param("questionnaireId") String questionnaireId, @Param("valueSetId") String valueSetId);
  /**
   * getQuestionnaireValueSets
   * 
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;ValueSet&gt;
   */
  @RequestLine("GET /questionnaires/{questionnaireId}/valueSets")
  @Headers({
      "Accept: application/json",
  })
  List<ValueSet> getQuestionnaireValueSets(@Param("questionnaireId") String questionnaireId);
  /**
   * getQuestionnaires
   * 
   * @param formId formId (optional)
   * @param formName Search questionnaires by formName. Should not be used together with formId. (optional)
   * @param formTag Search questionnaires by formTag. This is ignored, if formName is not set. (optional)
   * @param owner owner (optional)
   * @param status status (optional)
   * @return List&lt;QuestionnaireListItem&gt;
   */
  @RequestLine("GET /questionnaires?formId={formId}&formName={formName}&formTag={formTag}&owner={owner}&status={status}")
  @Headers({
      "Accept: application/json",
  })
  List<QuestionnaireListItem> getQuestionnaires(@Param("formId") String formId, @Param("formName") String formName, @Param("formTag") String formTag, @Param("owner") String owner, @Param("status") String status);

  /**
   * getQuestionnaires
   * 
   * Note, this is equivalent to the other <code>getQuestionnaires</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetQuestionnairesQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>formId - formId (optional)</li>
   *   <li>formName - Search questionnaires by formName. Should not be used together with formId. (optional)</li>
   *   <li>formTag - Search questionnaires by formTag. This is ignored, if formName is not set. (optional)</li>
   *   <li>owner - owner (optional)</li>
   *   <li>status - status (optional)</li>
   *   </ul>
   * @return List&lt;QuestionnaireListItem&gt;

   */
  @RequestLine("GET /questionnaires?formId={formId}&formName={formName}&formTag={formTag}&owner={owner}&status={status}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  List<QuestionnaireListItem> getQuestionnaires(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getQuestionnaires</code> method in a fluent style.
   */
  public static class GetQuestionnairesQueryParams extends HashMap<String, Object> {
    public GetQuestionnairesQueryParams formId(final String value) {
      put("formId", EncodingUtils.encode(value));
      return this;
    }
    public GetQuestionnairesQueryParams formName(final String value) {
      put("formName", EncodingUtils.encode(value));
      return this;
    }
    public GetQuestionnairesQueryParams formTag(final String value) {
      put("formTag", EncodingUtils.encode(value));
      return this;
    }
    public GetQuestionnairesQueryParams owner(final String value) {
      put("owner", EncodingUtils.encode(value));
      return this;
    }
    public GetQuestionnairesQueryParams status(final String value) {
      put("status", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * postQuestionnaire
   * 
   * @param body New questionnaire object (required)
   * @return IdAndRevision
   */
  @RequestLine("POST /questionnaires")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  IdAndRevision postQuestionnaire(Questionnaire body);
  /**
   * postQuestionnaireItemRow
   * 
   * @param itemId itemId (required)
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;String&gt;
   */
  @RequestLine("POST /questionnaires/{questionnaireId}/items/{itemId}/rows")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  List<String> postQuestionnaireItemRow(@Param("itemId") String itemId, @Param("questionnaireId") String questionnaireId);
  /**
   * putQuestionnaire
   * 
   * @param body Questionnaire object to replace existing state (required)
   * @param questionnaireId questionnaireId (required)
   * @return Questionnaire
   */
  @RequestLine("PUT /questionnaires/{questionnaireId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Questionnaire putQuestionnaire(Questionnaire body, @Param("questionnaireId") String questionnaireId);
  /**
   * putQuestionnaireAnswer
   * 
   * @param body New answer for single question (required)
   * @param answerId answerId (required)
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;Error&gt;
   */
  @RequestLine("PUT /questionnaires/{questionnaireId}/answers/{answerId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  List<Error> putQuestionnaireAnswer(Object body, @Param("answerId") String answerId, @Param("questionnaireId") String questionnaireId);
  /**
   * putQuestionnaireAnswers
   * 
   * @param body New answers for questionnaire (required)
   * @param questionnaireId questionnaireId (required)
   * @return List&lt;Error&gt;
   */
  @RequestLine("POST /questionnaires/{questionnaireId}/answers")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  List<Error> putQuestionnaireAnswers(List<Answer> body, @Param("questionnaireId") String questionnaireId);
  /**
   * putQuestionnairePages
   * 
   * @param body Updates questionnaire active page (required)
   * @param questionnaireId questionnaireId (required)
   * @return Items
   */
  @RequestLine("PUT /questionnaires/{questionnaireId}/pages")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Items putQuestionnairePages(Items body, @Param("questionnaireId") String questionnaireId);
  /**
   * putQuestionnaireStatus
   * 
   * @param body A new status for questionnaire (required)
   * @param questionnaireId questionnaireId (required)
   * @return String
   */
  @RequestLine("PUT /questionnaires/{questionnaireId}/status")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  String putQuestionnaireStatus(String body, @Param("questionnaireId") String questionnaireId);
}
