package io.dialob.api.client;

import io.dialob.api.client.okhttp.ApiClient;
import io.dialob.api.client.okhttp.EncodingUtils;

import io.dialob.api.rest.Errors;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.api.form.FormTag;
import io.dialob.api.rest.Response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import feign.*;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-03-15T08:57:32.972245Z[Etc/UTC]")public interface DialobFormServiceApi extends ApiClient.Api {

  /**
   * deleteForm
   * 
   * @param formId formId (required)
   * @return Response
   */
  @RequestLine("DELETE /forms/{formId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: */*,*/*,*/*,*/*",
  })
  Response deleteForm(@Param("formId") String formId);
  /**
   * getForm
   * 
   * @param formId formId (required)
   * @param rev rev (optional)
   * @return Form
   */
  @RequestLine("GET /forms/{formId}?rev={rev}")
  @Headers({
      "Accept: application/json",
  })
  Form getForm(@Param("formId") String formId, @Param("rev") String rev);

  /**
   * getForm
   * 
   * Note, this is equivalent to the other <code>getForm</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetFormQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param formId formId (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>rev - rev (optional)</li>
   *   </ul>
   * @return Form

   */
  @RequestLine("GET /forms/{formId}?rev={rev}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  Form getForm(@Param("formId") String formId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getForm</code> method in a fluent style.
   */
  public static class GetFormQueryParams extends HashMap<String, Object> {
    public GetFormQueryParams rev(final String value) {
      put("rev", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * getFormTag
   * 
   * @param formId formId (required)
   * @param tagName tagName (required)
   * @return FormTag
   */
  @RequestLine("GET /forms/{formId}/tags/{tagName}")
  @Headers({
      "Accept: application/json",
  })
  FormTag getFormTag(@Param("formId") String formId, @Param("tagName") String tagName);
  /**
   * getFormTags
   * 
   * @param formId formId (required)
   * @return List&lt;FormTag&gt;
   */
  @RequestLine("GET /forms/{formId}/tags")
  @Headers({
      "Accept: application/json",
  })
  List<FormTag> getFormTags(@Param("formId") String formId);
  /**
   * getTags
   * 
   * @param formId formId (optional)
   * @param formName formName (optional)
   * @param name name (optional)
   * @return List&lt;FormTag&gt;
   */
  @RequestLine("GET /tags?formId={formId}&formName={formName}&name={name}")
  @Headers({
      "Accept: application/json",
  })
  List<FormTag> getTags(@Param("formId") String formId, @Param("formName") String formName, @Param("name") String name);

  /**
   * getTags
   * 
   * Note, this is equivalent to the other <code>getTags</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link GetTagsQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>formId - formId (optional)</li>
   *   <li>formName - formName (optional)</li>
   *   <li>name - name (optional)</li>
   *   </ul>
   * @return List&lt;FormTag&gt;

   */
  @RequestLine("GET /tags?formId={formId}&formName={formName}&name={name}")
  @Headers({
      "Content-Type: */*",
      "Accept: application/json",
  })
  List<FormTag> getTags(@QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>getTags</code> method in a fluent style.
   */
  public static class GetTagsQueryParams extends HashMap<String, Object> {
    public GetTagsQueryParams formId(final String value) {
      put("formId", EncodingUtils.encode(value));
      return this;
    }
    public GetTagsQueryParams formName(final String value) {
      put("formName", EncodingUtils.encode(value));
      return this;
    }
    public GetTagsQueryParams name(final String value) {
      put("name", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * postForm
   * 
   * @param body New form (required)
   * @return Form
   */
  @RequestLine("POST /forms")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Form postForm(Form body);
  /**
   * postFormTag
   * 
   * @param body New tag (required)
   * @param formId formId (required)
   * @param rev rev (optional)
   * @param snapshot snapshot (optional, default to false)
   * @return Response
   */
  @RequestLine("POST /forms/{formId}/tags?rev={rev}&snapshot={snapshot}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Response postFormTag(FormTag body, @Param("formId") String formId, @Param("rev") String rev, @Param("snapshot") Boolean snapshot);

  /**
   * postFormTag
   * 
   * Note, this is equivalent to the other <code>postFormTag</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link PostFormTagQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param body New tag (required)
   * @param formId formId (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>rev - rev (optional)</li>
   *   <li>snapshot - snapshot (optional, default to false)</li>
   *   </ul>
   * @return Response

   */
  @RequestLine("POST /forms/{formId}/tags?rev={rev}&snapshot={snapshot}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Response postFormTag(FormTag body, @Param("formId") String formId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>postFormTag</code> method in a fluent style.
   */
  public static class PostFormTagQueryParams extends HashMap<String, Object> {
    public PostFormTagQueryParams rev(final String value) {
      put("rev", EncodingUtils.encode(value));
      return this;
    }
    public PostFormTagQueryParams snapshot(final Boolean value) {
      put("snapshot", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * putForm
   * 
   * @param body New form data (required)
   * @param formId formId (required)
   * @param force Should update ignore revision number check. (forced update) (optional, default to false)
   * @param newId New name for identifier (optional)
   * @param oldId Identifier to rename (optional)
   * @return FormPutResponse
   */
  @RequestLine("PUT /forms/{formId}?force={force}&newId={newId}&oldId={oldId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  FormPutResponse putForm(Form body, @Param("formId") String formId, @Param("force") Boolean force, @Param("newId") String newId, @Param("oldId") String oldId);

  /**
   * putForm
   * 
   * Note, this is equivalent to the other <code>putForm</code> method,
   * but with the query parameters collected into a single Map parameter. This
   * is convenient for services with optional query parameters, especially when
   * used with the {@link PutFormQueryParams} class that allows for
   * building up this map in a fluent style.
   * @param body New form data (required)
   * @param formId formId (required)
   * @param queryParams Map of query parameters as name-value pairs
   *   <p>The following elements may be specified in the query map:</p>
   *   <ul>
   *   <li>force - Should update ignore revision number check. (forced update) (optional, default to false)</li>
   *   <li>newId - New name for identifier (optional)</li>
   *   <li>oldId - Identifier to rename (optional)</li>
   *   </ul>
   * @return FormPutResponse

   */
  @RequestLine("PUT /forms/{formId}?force={force}&newId={newId}&oldId={oldId}")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  FormPutResponse putForm(Form body, @Param("formId") String formId, @QueryMap(encoded=true) Map<String, Object> queryParams);

  /**
   * A convenience class for generating query parameters for the
   * <code>putForm</code> method in a fluent style.
   */
  public static class PutFormQueryParams extends HashMap<String, Object> {
    public PutFormQueryParams force(final Boolean value) {
      put("force", EncodingUtils.encode(value));
      return this;
    }
    public PutFormQueryParams newId(final String value) {
      put("newId", EncodingUtils.encode(value));
      return this;
    }
    public PutFormQueryParams oldId(final String value) {
      put("oldId", EncodingUtils.encode(value));
      return this;
    }
  }
  /**
   * putFormTagLatest
   * 
   * @param body param1 (required)
   * @param formId formId (required)
   * @return Response
   */
  @RequestLine("PUT /forms/{formId}/tags/latest")
  @Headers({
      "Content-Type: application/json",
      "Accept: application/json",
  })
  Response putFormTagLatest(FormTag body, @Param("formId") String formId);
}
