package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;


public class UserPropertyModel implements IDataModel {
    public final String userSnapshotId;
    public final Map<String, Object> properties;

    public UserPropertyModel(String userSnapshotId, Map<String, Object> properties) {
        this.userSnapshotId = userSnapshotId;
        this.properties = properties;
    }

    @Override
    public JSONObject getJson() throws JSONException {

        JSONObject propertiesJson = new JSONObject();

        for (String key : this.properties.keySet()) {
            propertiesJson.put(key, this.properties.get(key));
        }

        return propertiesJson;
    }
}
