package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.domain.CoreConstants;

public class InAppMessageApiModel implements IApiModel {
    private final IDataModel commonModel;
    private final String checksum;
    private final String userId;
    private final JSONArray requiredCampaignIds;
    private final JSONObject supportedLayout;

    public InAppMessageApiModel(
            IDataModel commonModel,
            String checksum,
            String userId,
            JSONArray requiredCampaignIds,
            JSONObject supportedLayout
    ) {
        this.commonModel = commonModel;
        this.checksum = checksum;
        this.userId = userId;
        this.requiredCampaignIds = requiredCampaignIds;
        this.supportedLayout = supportedLayout;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();

        JSONObject inAppMessageJSONObject = new JSONObject();
        inAppMessageJSONObject.put("checksum", checksum);
        inAppMessageJSONObject.put("user_id", userId == null ? JSONObject.NULL : userId);
        inAppMessageJSONObject.put("required_campaign_ids", requiredCampaignIds == null ? JSONObject.NULL : requiredCampaignIds);
        inAppMessageJSONObject.put("supported_layout", supportedLayout == null ? JSONObject.NULL : supportedLayout);

        root.put("common", commonModel.getJson());
        root.put("in_app_message", inAppMessageJSONObject);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.inAppMessageUrlTemplate;
    }
}
