package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.utils.CoreUtils;

public class IdentityModel implements IDataModel {
    public String adid;
    public String gaid;
    public String uuid;
    public String idfa;
    public String idfv;
    public String igawId;
    public boolean adIdOptOut;
    public String deviceId;
    public String registrationId;
    public boolean isPushEnable;
    public boolean isPushEnableOs;

    public IdentityModel(
            String adid,
            String gaid,
            String uuid,
            String idfa,
            String idfv,
            String igawId,
            boolean adIdOptOut,
            String deviceId,
            String registrationId,
            boolean isPushEnable,
            boolean isPushEnableOs
    ) {
        if (adid == null) {
            this.adid = "uuid:" + uuid;
        } else {
            this.adid = adid;
        }
        this.gaid = gaid;
        this.uuid = uuid;
        this.idfa = idfa;
        this.idfv = idfv;
        this.igawId = igawId;
        this.adIdOptOut = adIdOptOut;
        this.deviceId = deviceId;
        this.registrationId = registrationId;
        this.isPushEnable = isPushEnable;
        this.isPushEnableOs = isPushEnableOs;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();

        root.put("adid", this.adid);
        root.put("gaid", CoreUtils.convertNullableToJSONNullable(this.gaid));
        root.put("uuid", this.uuid);
        root.put("idfa", CoreUtils.convertNullableToJSONNullable(this.idfa));
        root.put("idfv", CoreUtils.convertNullableToJSONNullable(this.idfv));
        root.put("igaw_id", this.igawId);
        root.put("ad_id_opt_out", this.adIdOptOut);
        root.put("device_id", CoreUtils.convertNullableToJSONNullable(this.deviceId));
        root.put("registration_id", CoreUtils.convertNullableToJSONNullable(this.registrationId));
        root.put("is_push_enable", this.isPushEnable);
        root.put("is_push_enable_os", this.isPushEnableOs);

        return root;
    }
}
