package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.domain.CoreConstants;

public class GDPRModel implements IApiModel {
    private String subjectRequestId = null;
    private String subjectRequestType = null;
    private String submittedTime = null;
    private JSONArray subjectIdentities = null;
    private String apiVersion = null;
    private String statusCallbackUrls = null;
    private JSONObject extensions = null;

    public GDPRModel(
            String subjectRequestId,
            String subjectRequestType,
            String submittedTime,
            JSONArray subjectIdentities,
            String apiVersion,
            String statusCallbackUrls,
            JSONObject extensions
    ) {
        this.subjectRequestId = subjectRequestId;
        this.subjectRequestType = subjectRequestType;
        this.submittedTime = submittedTime;
        this.subjectIdentities = subjectIdentities;
        this.apiVersion = apiVersion;
        this.statusCallbackUrls = statusCallbackUrls;
        this.extensions = extensions;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        root.put("subject_request_id", subjectRequestId);
        root.put("subject_request_type", subjectRequestType);
        root.put("submitted_time", submittedTime);
        root.put("subject_identities", subjectIdentities);
        root.put("api_version", apiVersion);
        root.put("status_callback_urls", statusCallbackUrls);
        root.put("extensions", extensions);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.gdprUrlReq;
    }
}
