package io.adbrix.sdk.domain.model;

import android.graphics.Bitmap;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.TryOptional;
import io.adbrix.sdk.domain.IAMConstants;
import io.adbrix.sdk.utils.CoreUtils;

public class DfnInAppMessage {
    @Nullable public final String campaignId;
    @Nullable public final String type;
    @Nullable public final String layout;
    @Nullable public final String bgColor;
    @Nullable public final String overlayColor;
    @Nullable public final String titleText;
    @Nullable public final String titleTextColor;
    @Nullable public final String bodyText;
    @Nullable public final String bodyTextColor;
    @Nullable public final String textAlign;
    @Nullable public final String defaultCloseButtonColor;
    @Nullable public final String defaultCloseButtonBgColor;
    @Nullable public final JSONObject stickyBannerClickOption;
    @Nullable public final JSONObject scrollableImageOption;
    public final int numberOfButtons;
    @Nullable public final JSONArray buttonArray;
    public final String blackColor = "#000000";
    public final String whiteColor = "#FFFFFF";
    @Nullable public Bitmap portraitImage;
    @Nullable public String portraitImageURL;
    @Nullable public Boolean isPortraitImageDownloaded;
    @Nullable public Bitmap landscapeImage;
    @Nullable public String landscapeImageURL;
    @Nullable public Boolean isLandscapeImageDownloaded;
    @Nullable public JSONObject imageClickAction;
    public final long startDateTime;
    public final long endDateTime;
    @Nullable public final JSONObject extAttr;
    @Nullable public final DfnGrowthEventParam growthEventParam;
    public final List<DfnIAMTrigger> triggers;

    public DfnInAppMessage(
            @Nullable String campaignId,
            @Nullable String type,
            @Nullable String layout,
            @Nullable String bgColor,
            @Nullable String overlayColor,
            @Nullable String titleText,
            @Nullable String titleTextColor,
            @Nullable String bodyText,
            @Nullable String bodyTextColor,
            @Nullable String textAlign,
            @Nullable String defaultCloseButtonColor,
            @Nullable String defaultCloseButtonBgColor,
            @Nullable JSONObject stickyBannerClickOption,
            @Nullable JSONObject scrollableImageOption,
            int numberOfButtons,
            @Nullable JSONArray buttonArray,
            @Nullable String portraitImageURL,
            @Nullable String landscapeImageURL,
            @Nullable JSONObject imageClickAction,
            long startDateTime,
            long endDateTime,
            @Nullable JSONObject extAttr,
            @Nullable DfnGrowthEventParam growthEventParam,
            List<DfnIAMTrigger> triggers
    ) {
        String nullString = "null";
        String defaultOverlayColor = "#EEEEEEEE";

        this.campaignId = campaignId;
        this.type = type;
        this.layout = layout;
        this.bgColor = bgColor == null || bgColor.equals(nullString) ? whiteColor : bgColor;
        this.overlayColor = overlayColor == null || overlayColor.equals(nullString) ? defaultOverlayColor : overlayColor;
        this.titleText = titleText;
        this.titleTextColor = titleTextColor;
        this.bodyText = bodyText;
        this.bodyTextColor = bodyTextColor;
        this.textAlign = textAlign;
        this.defaultCloseButtonColor = defaultCloseButtonColor == null || defaultCloseButtonColor.equals(nullString) ? whiteColor : defaultCloseButtonColor;
        this.defaultCloseButtonBgColor = defaultCloseButtonBgColor == null || defaultCloseButtonBgColor.equals(nullString) ? blackColor : defaultCloseButtonBgColor;
        this.stickyBannerClickOption = stickyBannerClickOption;
        this.scrollableImageOption = scrollableImageOption;
        this.numberOfButtons = numberOfButtons;
        this.buttonArray = buttonArray;
        this.portraitImageURL = portraitImageURL;
        this.landscapeImageURL = landscapeImageURL;
        this.imageClickAction = imageClickAction;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.extAttr = extAttr;
        this.growthEventParam = growthEventParam;
        this.triggers = triggers;
    }

    public DfnInAppMessage(
            @Nullable String campaignId,
            @Nullable String type,
            @Nullable String layout,
            @Nullable Bitmap portraitImage,
            @Nullable String portraitURL,
            @Nullable Boolean isPortraitImageDownloaded,
            @Nullable Bitmap landscapeImage,
            @Nullable String landscapeURL,
            @Nullable Boolean isLandscapeImageDownloaded,
            String imageClickAction,
            String bgColor,
            String overlayColor,
            String text,
            String buttonArray,
            String defaultCloseButtonColor,
            String defaultCloseButtonBgColor,
            String stickyBannerClickOption,
            String scrollableImageOption,
            long startDateTime,
            long endDateTime,
            String extAttrString,
            String extConfigString,
            List<DfnIAMTrigger> triggers
    ) {
        String nullString = "null";
        String defaultOverlayColor = "#EEEEEEEE";

        this.campaignId = campaignId;
        this.type = type;
        this.layout = layout;
        this.portraitImage = portraitImage;
        this.portraitImageURL = portraitURL;
        this.isPortraitImageDownloaded = isPortraitImageDownloaded;
        this.landscapeImage = landscapeImage;
        this.landscapeImageURL = landscapeURL;
        this.isLandscapeImageDownloaded = isLandscapeImageDownloaded;
        this.bgColor = nullString.equals(bgColor) ? whiteColor : bgColor;
        this.overlayColor = nullString.equals(overlayColor) ? defaultOverlayColor : overlayColor;
        this.defaultCloseButtonColor = defaultCloseButtonColor == null || nullString.equals(defaultCloseButtonColor) ? whiteColor : defaultCloseButtonColor;
        this.defaultCloseButtonBgColor = defaultCloseButtonBgColor == null || nullString.equals(defaultCloseButtonBgColor) ? blackColor : defaultCloseButtonBgColor;

        int tempNumberOfButtons;
        JSONArray tempButtonArray;
        JSONObject tempStickyBannerClickOption;
        JSONObject tempScrollableImageOption;
        JSONObject tempExtAttr;
        DfnGrowthEventParam tempDfnGrowthEventParam;
        JSONObject textJsonObject;
        String tempTitleText = "";
        String tempTitleTextColor = blackColor;
        String tempBodyText = "";
        String tempBodyTextColor = blackColor;
        String tempTextAlign = IAMEnums.TextAlign.CENTER.getValue();
        JSONObject imageClickActionJsonObject;

        try {
            if (stickyBannerClickOption != null) {
                tempStickyBannerClickOption = new JSONObject(stickyBannerClickOption);
            } else {
                tempStickyBannerClickOption = null;
            }

            if (scrollableImageOption != null) {
                tempScrollableImageOption = new JSONObject(scrollableImageOption);
            } else {
                tempScrollableImageOption = null;
            }

            if (extAttrString != null) {
                tempExtAttr = new JSONObject(extAttrString);
            } else {
                tempExtAttr = null;
            }

            if (extConfigString != null) {
                tempDfnGrowthEventParam = DfnGrowthEventParam.fromJSON(extConfigString);
            } else {
                tempDfnGrowthEventParam = null;
            }

            if (buttonArray != null) {
                tempButtonArray = new JSONArray(buttonArray);
            } else {
                tempButtonArray = null;
            }

            if (tempButtonArray == null) {
                tempNumberOfButtons = 0;
            } else {
                tempNumberOfButtons = tempButtonArray.length();
            }

            if (text == null) {
                textJsonObject = null;
            } else {
                textJsonObject = new JSONObject(text);
            }

            if (text != null) {
                tempTitleText = textJsonObject.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_TITLE);
                tempTitleTextColor = textJsonObject.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_TITLE_COLOR);
                tempBodyText = textJsonObject.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_BODY);
                tempBodyTextColor = textJsonObject.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_BODY_COLOR);
                tempTextAlign = textJsonObject.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_ALIGN);
            }

            if (imageClickAction == null) {
                imageClickActionJsonObject = null;
            } else {
                imageClickActionJsonObject = new JSONObject(imageClickAction);
            }
        } catch (JSONException e) {
            tempButtonArray = new JSONArray();
            tempNumberOfButtons = 0;
            tempStickyBannerClickOption = new JSONObject();
            tempScrollableImageOption = new JSONObject();
            imageClickActionJsonObject = new JSONObject();
            tempExtAttr = new JSONObject();
            tempDfnGrowthEventParam = null;
        }

        this.buttonArray = tempButtonArray;
        this.numberOfButtons = tempNumberOfButtons;
        this.stickyBannerClickOption = tempStickyBannerClickOption;
        this.scrollableImageOption = tempScrollableImageOption;
        this.titleText = tempTitleText;
        this.titleTextColor = tempTitleTextColor;
        this.bodyText = tempBodyText;
        this.bodyTextColor = tempBodyTextColor;
        this.textAlign = tempTextAlign;
        this.imageClickAction = imageClickActionJsonObject;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.extAttr = tempExtAttr;
        this.growthEventParam = tempDfnGrowthEventParam;
        this.triggers = triggers;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public String getType() {
        return type;
    }

    public String getLayout() {
        return layout;
    }

    public Bitmap getPortraitImage() {
        return portraitImage;
    }

    public void setPortraitImage(Bitmap portraitImage) {
        this.portraitImage = portraitImage;
    }

    public String getPortraitImageURL() {
        return portraitImageURL;
    }

    public void setPortraitImageURL(String portraitImageURL) {
        this.portraitImageURL = portraitImageURL;
    }

    public boolean getsIsPortraitImageDownloaded() {
        return isPortraitImageDownloaded == null ? false : isPortraitImageDownloaded;
    }

    public Bitmap getLandScapeImage() {
        return landscapeImage;
    }

    public String getLandscapeImageURL() {
        return landscapeImageURL;
    }

    public void setLandscapeImageURL(String landscapeImageURL) {
        this.landscapeImageURL = landscapeImageURL;
    }

    public boolean getsIsLandscapeImageDownloaded() {
        return isLandscapeImageDownloaded == null ? false : isLandscapeImageDownloaded;
    }

    public String getImageClickActionId() {
        try {
            return imageClickAction.optString(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_ID);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getImageClickActionType() {
        try {
            return imageClickAction.optString(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_TYPE);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getImageClickActionArg() {
        try {
            return imageClickAction.optString(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_ARG);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getTitleText() {
        return titleText;
    }

    public String getTitleTextColor() {
        return titleTextColor;
    }

    public String getBodyText() {
        return bodyText;
    }

    public String getBodyTextColor() {
        return bodyTextColor;
    }

    public String getTextAlign() {
        return textAlign;
    }

    public String getBgColor() {
        return bgColor;
    }

    public String getOverlayColor() {
        return overlayColor;
    }

    public int getNumberOfButtons() {
        return numberOfButtons;
    }

    public String getButtonId(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_BUTTON_ID))
                .orElse(null);
    }

    public String getButtonText(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_TEXT))
                .orElse(null);
    }

    public String getButtonActionID(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION))
                .mapCatching(clickAction -> clickAction.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ID))
                .orElse(null);
    }

    public String getButtonActionType(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION))
                .mapCatching(clickAction -> clickAction.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ACTION_TYPE))
                .orElse(null);
    }

    public String getButtonActionArgument(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION))
                .mapCatching(clickAction -> clickAction.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ACTION_ARG))
                .orElse(null);
    }

    public String getButtonTextColor(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_TEXT_COLOR))
                .orElse(blackColor);
    }

    public String getButtonBackgroundColor(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_BG_COLOR))
                .orElse(whiteColor);
    }

    public String getButtonBoarderColor(int index) {
        return TryOptional.of(() -> buttonArray.getJSONObject(index))
                .mapCatching(button -> button.getString(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS_BORDER_COLOR))
                .orElse(blackColor);
    }

    public String getDefaultCloseButtonColor() {
        return defaultCloseButtonColor;
    }

    public String getDefaultCloseButtonBgColor() {
        return defaultCloseButtonBgColor;
    }

    public String getStickyBannerAlign() {
        return TryOptional.of(() -> stickyBannerClickOption.optString(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_ALIGN))
                .orElse(null);
    }

    public String getStickBannerClickActionActionID() {
        try {
            return this.stickyBannerClickOption.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION).getString(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_ID);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getStickBannerClickActionActionType() {
        return TryOptional.of(() -> stickyBannerClickOption.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION))
                .mapCatching(clickAction -> clickAction.getString(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_TYPE))
                .orElse(null);
    }

    public String getStickBannerClickOptionActionArg() {
        return TryOptional.of(() -> stickyBannerClickOption.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION))
                .mapCatching(clickAction -> clickAction.getString(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_ARG))
                .orElse(null);
    }

    public String getScrollableImageOptionAlign() {
        return TryOptional.of(() -> scrollableImageOption.getString(IAMConstants.RESPONSE_IAM_CONTENTS_SCROLLABLE_IMAGE_OPTION_ALIGN))
                .orElse(null);
    }

    public void setIsPortraitImageDownloaded(Boolean isPortraitImageDownloaded) {
        this.isPortraitImageDownloaded = isPortraitImageDownloaded;
    }

    public void setLandscapeImage(Bitmap landscapeImage) {
        this.landscapeImage = landscapeImage;
    }

    public void setIsLandscapeImageDownloaded(Boolean isLandscapeImageDownloaded) {
        this.isLandscapeImageDownloaded = isLandscapeImageDownloaded;
    }

    public void setImageClickAction(String imageClickAction) {
        try {
            this.imageClickAction = new JSONObject(imageClickAction);
        } catch (JSONException jsonException) {
            this.imageClickAction = null;
        }
    }

    public static List<DfnInAppMessage> fromJSON(String responseJsonString) {
        List<DfnInAppMessage> inAppMessageList = new ArrayList<>();

        try {
            JSONObject response = new JSONObject(responseJsonString);
            JSONObject data = response.getJSONObject(IAMConstants.RESPONSE_DATA);
            JSONArray inAppMessages = data.getJSONArray(IAMConstants.RESPONSE_IAM);

            for (int i = 0; i < inAppMessages.length(); i++) {
                JSONObject inAppMessageJson = inAppMessages.getJSONObject(i);
                JSONObject contents = inAppMessageJson.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS);
                JSONObject image = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE);
                JSONObject clickAction = image == null ? null : image.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION);
                JSONObject url = image == null ? null : image.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_URL);
                JSONObject bgStyle = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE);
                JSONObject text = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT);
                JSONArray buttons = contents == null ? null : contents.optJSONArray(IAMConstants.RESPONSE_IAM_CONTENTS_BUTTONS);
                JSONObject defaultCloseButton = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_DEFAULT_CLOSE_BUTTON);
                JSONObject stickyBannerOption = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION);
                JSONObject scrollableImageOption = contents == null ? null : contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_SCROLLABLE_IMAGE_OPTION);
                JSONObject extConfig = inAppMessageJson.optJSONObject(IAMConstants.RESPONSE_IAM_EXT_CONFIG);
                JSONArray triggersArray = inAppMessageJson.optJSONArray(IAMConstants.RESPONSE_IAM_TRIGGERS);
                List<DfnIAMTrigger> triggers = new ArrayList<>();

                for (int j = 0; triggersArray != null && j < triggersArray.length(); j++) {
                    JSONObject trigger = triggersArray.getJSONObject(j);

                    triggers.add(
                            new DfnIAMTrigger(
                                    trigger.optString(IAMConstants.RESPONSE_IAM_TRIGGERS_TYPE),
                                    trigger.optString(IAMConstants.RESPONSE_IAM_TRIGGERS_EVT),
                                    trigger.optInt(IAMConstants.RESPONSE_IAM_TRIGGERS_PRIORITY)
                            )
                    );
                }

                DfnInAppMessage inAppMessage = new DfnInAppMessage(
                        inAppMessageJson.optString(IAMConstants.RESPONSE_IAM_CAMPAIGN_ID),
                        inAppMessageJson.optString(IAMConstants.RESPONSE_IAM_TYPE),
                        inAppMessageJson.optString(IAMConstants.RESPONSE_IAM_LAYOUT),
                        bgStyle == null ? null : bgStyle.optString(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE_BG_COLOR, "#FFFFFF"),
                        bgStyle == null ? null : bgStyle.optString(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE_OVERLAY_COLOR, "#EEEEEEEE"),
                        text == null ? "" : text.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_TITLE),
                        text == null ? "#000000" : text.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_TITLE_COLOR, "#000000"),
                        text == null ? "" : text.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_BODY),
                        text == null ? "#000000" : text.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_BODY_COLOR, "#000000"),
                        text == null ? IAMEnums.TextAlign.CENTER.getValue() : text.optString(IAMConstants.RESPONSE_IAM_CONTENTS_TEXT_ALIGN, IAMEnums.TextAlign.CENTER.getValue()),
                        defaultCloseButton == null ? null : defaultCloseButton.optString(IAMConstants.RESPONSE_IAM_CONTENTS_DEFAULT_CLOSE_BUTTON_COLOR),
                        defaultCloseButton == null ? null : defaultCloseButton.optString(IAMConstants.RESPONSE_IAM_CONTENTS_DEFAULT_CLOSE_BUTTON_BG_COLOR),
                        stickyBannerOption,
                        scrollableImageOption,
                        buttons == null ? 0 : buttons.length(),
                        buttons,
                        url == null ? null : url.optString(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_URL_PORTRAIT),
                        url == null ? null : url.optString(IAMConstants.RESPONSE_IAM_CONTENTS_IMAGE_URL_LANDSCAPE),
                        clickAction,
                        CoreUtils.getStartDateTimeLong(inAppMessageJson.optString(IAMConstants.RESPONSE_IAM_START_DATETIME)),
                        CoreUtils.getEndDateTimeLong(inAppMessageJson.optString(IAMConstants.RESPONSE_IAM_END_DATETIME)),
                        inAppMessageJson.optJSONObject(IAMConstants.RESPONSE_IAM_EXT_ATTR),
                        extConfig == null ? null : DfnGrowthEventParam.fromJSON(extConfig.toString()),
                        triggers
                );

                inAppMessageList.add(inAppMessage);
            }

            return inAppMessageList;
        } catch (Exception e) {
            return inAppMessageList;
        }
    }

    @Override
    public String toString() {
        return "DfnInAppMessage{" +
                "campaignId='" + campaignId + '\'' +
                ", type='" + type + '\'' +
                ", layout='" + layout + '\'' +
                ", bgColor='" + bgColor + '\'' +
                ", overlayColor='" + overlayColor + '\'' +
                ", titleText='" + titleText + '\'' +
                ", titleTextColor='" + titleTextColor + '\'' +
                ", bodyText='" + bodyText + '\'' +
                ", bodyTextColor='" + bodyTextColor + '\'' +
                ", textAlign='" + textAlign + '\'' +
                ", defaultCloseButtonColor='" + defaultCloseButtonColor + '\'' +
                ", defaultCloseButtonBgColor='" + defaultCloseButtonBgColor + '\'' +
                ", stickyBannerClickOption=" + stickyBannerClickOption +
                ", scrollableImageOption=" + scrollableImageOption +
                ", numberOfButtons=" + numberOfButtons +
                ", buttonArray=" + buttonArray +
                ", blackColor='" + blackColor + '\'' +
                ", whiteColor='" + whiteColor + '\'' +
                ", portraitImage=" + portraitImage +
                ", portraitImageURL='" + portraitImageURL + '\'' +
                ", isPortraitImageDownloaded=" + isPortraitImageDownloaded +
                ", landscapeImage=" + landscapeImage +
                ", landscapeImageURL='" + landscapeImageURL + '\'' +
                ", isLandscapeImageDownloaded=" + isLandscapeImageDownloaded +
                ", imageClickAction=" + imageClickAction +
                ", startDateTime=" + startDateTime +
                ", endDateTime=" + endDateTime +
                ", extAttr=" + extAttr +
                ", growthEventParam=" + growthEventParam +
                ", triggers=" + triggers +
                '}';
    }
}
