package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

public class CommonModel implements IDataModel {
    public final String requestDatetime;
    public final IdentityModel identityModel;
    public final DeviceModel deviceInfo;
    public final String packageName;
    public final String appkey;
    public final String apiVersion;
    public final String sdkVersion;
    public final String installer;
    public final String appVersion;
    public final String buildId;

    public CommonModel(
            String requestDatetime,
            IdentityModel identityModel,
            DeviceModel deviceInfo,
            String packageName,
            String appkey,
            String apiVersion,
            String sdkVersion,
            String installer,
            String appVersion,
            String buildId
    ) {
        this.requestDatetime = requestDatetime;
        this.identityModel = identityModel;
        this.deviceInfo = deviceInfo;
        this.packageName = packageName;
        this.appkey = appkey;
        this.apiVersion = apiVersion;
        this.sdkVersion = sdkVersion;
        this.installer = installer;
        this.appVersion = appVersion;
        this.buildId = buildId;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();

        root.put("request_datetime", this.requestDatetime);
        root.put("identity", this.identityModel.getJson());
        root.put("device_info", this.deviceInfo.getJson());
        root.put("package_name", this.packageName);
        root.put("appkey", this.appkey);
        root.put("api_version", this.apiVersion);
        root.put("sdk_version", this.sdkVersion);
        root.put("installer", this.installer);
        root.put("app_version", this.appVersion);
        root.put("build_id", this.buildId);

        return root;
    }
}
