package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.CoreConstants;

public class ActionHistoryQueryModel implements IApiModel {
    private final CommonModel commonModel;
    private final List<String> actionType;
    private final int skip;
    private final int limit;
    private final long fromTimestamp;
    private final long toTimestamp;
    private final boolean ascending;
    @Nullable
    private final String userId;

    public ActionHistoryQueryModel(
            CommonModel commonModel,
            List<String> actionType,
            int skip,
            int limit,
            long fromTimestamp,
            long toTimestamp,
            boolean ascending,
            @Nullable
            String userId
    ) {
        this.commonModel = commonModel;
        this.actionType = actionType;
        this.skip = skip;
        this.limit = limit;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.ascending = ascending;
        this.userId = userId;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.actionHistoryQueryUrl;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject condition = new JSONObject();

        condition.put("action_type", new JSONArray(actionType))
                .put("skip", skip)
                .put("limit", limit)
                .put("from_timestamp", fromTimestamp)
                .put("to_timestamp", toTimestamp)
                .put("ascending", ascending)
                .put("user_id", userId);

        result.put("condition", condition);
        result.put("common", commonModel.getJson());

        return result;
    }
}
