package io.adbrix.sdk.domain.interactor;

import java.util.List;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Result;

public class GetAllActionHistoryUseCase implements UseCase<Void> {
    private final Repository repository;
    private final List<String> actionType;
    private final Completion<Result<List<ActionHistory>>> completion;

    public GetAllActionHistoryUseCase(
            Repository repository,
            List<String> actionType,
            Completion<Result<List<ActionHistory>>> completion
    ) {
        this.repository = repository;
        this.actionType = actionType;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.getAllActionHistory(actionType, completion);
        return null;
    }
}
