package io.adbrix.sdk.domain;

import android.app.Activity;

import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface Repository {
    EventModel getEventModel(LogEventParameter logEventParameter);

    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);

    void initDefaultConfigValue();

    void syncApplicationConfigure();

    void gdprForgetMe();

    //    void updateFavoriteApplication();
    void registerNetworkCallback();

    void unregisterNetworkCallback();

    void saveUnsentEvents();

    void logEvent(LogEventParameter logEventParameter);

    void logSameEventWithPaging(String eventName, List<JSONObject> eventParams);

    void flushAllNow();

    void flushAtIntervals();

    //InAppMessage
    void resetInAppMessageFrequencySession();

    void openInAppMessage(String eventName);

    void shutDownInAppMessageExecutor();

    void updateCurrentActivity(Activity activity);

    void deleteCurrentActivity(Activity activity);

    void dismissInAppMessageDialog(Activity destroyedActivity);

    void fetchInAppMessage(Completion<Result<Empty>> completion);

    void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion);

    void openInAppMessage(String campaignId, Completion<Result<Empty>> completion);

    void deleteAllInAppMessageDBContents();

    //DRWorks
    Result<Empty> deleteUserData(String userId);

    Result<Empty> restartSDK(String userId);

    //ActionHistory
    void fetchActionHistoryFromServer(@Nullable String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void insertPushData(String pushDataString);

    void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion);

    void deleteActionHistory(@Nullable String token, String historyId, long timestamp, Completion<Result<Empty>> completion);

    void deleteAllActionHistory(@Nullable String token, @Nullable ActionHistoryIdType idType, Completion<Result<Empty>> completion);

    void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion);

    void clearAllActionHistoryInLocalDB();
}
