package io.adbrix.sdk.data.modelprovider;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.GDPRModel;
import io.adbrix.sdk.utils.CommonUtils;

public class GDPRModelProvider implements IApiModelProvider<GDPRModel> {
    private DataRegistry dataRegistry;

    public GDPRModelProvider(DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
    }

    @Override
    public GDPRModel provide() {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);

        SimpleDateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        utcDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String submittedTime = utcDateFormat.format(new Date());

        JSONArray subjectIdentities = new JSONArray();
        JSONObject objSubjectIdentities = new JSONObject();
        JSONObject extensions = new JSONObject();

        try {
            objSubjectIdentities.put("identity_type", "android_advertising_id");
            objSubjectIdentities.put("identity_value", CommonUtils.replaceWithJSONNull(adid));
            objSubjectIdentities.put("identity_format", "raw");
            subjectIdentities.put(objSubjectIdentities);

            JSONObject gdpr = new JSONObject();
            gdpr.put("appkey", appKey);
            gdpr.put("type", "remaster");
            extensions.put("gdpr.adbrix.io", gdpr);

        } catch (JSONException e) {
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }

        return new GDPRModel(
                UUID.randomUUID().toString(),
                "erasure",
                submittedTime,
                subjectIdentities,
                "1.0",
                "",
                extensions
        );
    }
}
