package io.adbrix.sdk.data.modelprovider;

import android.content.Context;

import java.util.List;

import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.TryOptional;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.ActionHistoryQueryModel;

public class ActionHistoryQueryModelProvider implements IApiModelProvider<ActionHistoryQueryModel> {
    private final DataRegistry dataRegistry;
    private final Context context;
    private final DeviceRealtimeDataProvider deviceRealtimeDataProvider;
    private final IABXComponentsFactory componentsFactory;
    private final ActionHistoryIdType idType;
    private final List<String> actionTypes;
    private final int skip;
    private final int limit;
    private final long fromTimestamp;

    public ActionHistoryQueryModelProvider(
            DataRegistry dataRegistry,
            Context context,
            DeviceRealtimeDataProvider deviceRealtimeDataProvider,
            IABXComponentsFactory componentsFactory,
            ActionHistoryIdType idType,
            List<String> actionTypes,
            int skip,
            int limit,
            long fromTimestamp
    ) {
        this.dataRegistry = dataRegistry;
        this.context = context;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
        this.componentsFactory = componentsFactory;
        this.idType = idType;
        this.actionTypes = actionTypes;
        this.skip = skip;
        this.limit = limit;
        this.fromTimestamp = fromTimestamp;
    }

    @Override
    public ActionHistoryQueryModel provide() {
        CommonModelProvider commonModelProvider = new CommonModelProvider(dataRegistry, context, deviceRealtimeDataProvider);

        String userId = null;

        if (idType == ActionHistoryIdType.USER_ID) {
            userId = TryOptional.of(componentsFactory::createOrGetUserPropertyManager)
                    .map(userPropertyManager -> (String) userPropertyManager.getUserPropertyValue("user_id"))
                    .map(id -> id.replace("string:", ""))
                    .orElse(null);
        }

        return new ActionHistoryQueryModel(
                commonModelProvider.provide(),
                actionTypes,
                skip,
                limit,
                fromTimestamp,
                0,
                false,
                userId
        );
    }
}
