package io.adbrix.sdk.component;

import io.adbrix.sdk.domain.function.Supplier;

public class TryOptional<T, E extends Exception> {
    private final ThrowingSupplier<T, E> supplier;

    private TryOptional(ThrowingSupplier<T, E> supplier) {
        this.supplier = supplier;
    }

    public static <T, E extends Exception> Optional<T> of(ThrowingSupplier<T, E> supplier) {
        return new TryOptional<T, E>(supplier).get();
    }

    public static <T, E extends Exception> T optGet(ThrowingSupplier<T, E> throwingSupplier, Supplier<T> supplier) {
        try {
            return throwingSupplier.get();
        } catch (Exception e) {
            return supplier.get();
        }
    }

    private Optional<T> get() {
        try {
            return Optional.of(supplier.get());
        } catch (Exception e) {
            return Optional.empty();
        }
    }
}
