package io.adbrix.sdk.component;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushOpenMonitor {

    private AtomicBoolean isOpenedByPush;
    private Map<String, Object> pushOpenEventParam;

    private PushOpenMonitor() {
        isOpenedByPush = new AtomicBoolean(false);
    }

    public static PushOpenMonitor getInstance() {
        return Singleton.INSTANCE;
    }

    public Map<String, Object> getPushOpenEventParam() {
        return pushOpenEventParam;
    }

    public void setPushOpenEventParam(Map<String, Object> pushOpenEventParam) {
        this.pushOpenEventParam = pushOpenEventParam;
    }

    public boolean isOpenedByPush() {
        return isOpenedByPush.get();
    }

    public void setOpenedByPush(boolean openedByPush) {
        isOpenedByPush.getAndSet(openedByPush);
    }

    public void refresh() {
        isOpenedByPush.getAndSet(false);
    }

    private static class Singleton {
        private static final PushOpenMonitor INSTANCE = new PushOpenMonitor();
    }
}
