package io.adbrix.sdk.component;

import android.content.Context;

import io.adbrix.sdk.component.autoEvent.DailyFirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.datasource.IDataContext;
import io.adbrix.sdk.domain.Repository;

public interface IABXComponentsFactory {

    ILogger createOrGetLogger();

    DataRegistry createOrGetDataRegistry() throws ComponentsCanNotCreateException;

    IDataContext createOrGetDataContext() throws ComponentsCanNotCreateException;

    DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider() throws ComponentsCanNotCreateException;

    DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() throws ComponentsCanNotCreateException;

    V1MigrationManager createOrGetV1MigrationManager() throws ComponentsCanNotCreateException;

    Context getAndroidContext() throws ComponentsCanNotCreateException;

    void setAndroidContext(Context context);

    UserPropertyManager createOrGetUserPropertyManager() throws ComponentsCanNotCreateException;

    IEventSender createOrGetEventSender() throws ComponentsCanNotCreateException;

    IABXContext getABXContext() throws ComponentsCanNotCreateException;

    void setABXContext(IABXContext context);

    FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException;

    DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator() throws ComponentsCanNotCreateException;

    SessionAutoEventGenerator createOrGetSessionAutoEventGenerator() throws ComponentsCanNotCreateException;

    DeeplinkParameterSet createOrGetDeeplinkParameterSet() throws ComponentsCanNotCreateException;

    Repository createOrGetRepository() throws ComponentsCanNotCreateException;

    EventBuffer createOrGetEventBuffer() throws ComponentsCanNotCreateException;

    EventPackageContainer createOrGetEventPackageContainer() throws ComponentsCanNotCreateException;

    DailyFirstOpenAutoEventGenerator createOrGetDailyFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException;

    V1DatabaseOpenHelper createOrGetV1DatabaseOpenHelper() throws ComponentsCanNotCreateException;

    EventSamplingFilter createOrGetEventSamplingFilter() throws ComponentsCanNotCreateException;

    void activate();
    void deactivate();

    class ComponentsCanNotCreateException extends Exception {
        public ComponentsCanNotCreateException(String message) {
            super(message);
        }
    }
}


