package io.adbrix.sdk.domain.model;

import io.adbrix.sdk.domain.function.Completion;

public final class Success<T> implements Result<T> {
    private static final Success<?> EMPTY = new Success<>(Empty.INSTANCE);
    T data;

    private Success(T data) {
        this.data = data;
    }

    public static <T> Success<T> of(T data) {
        return new Success<>(data);
    }

    @SuppressWarnings("unchecked")
    public static <T> Success<T> empty() {
        return (Success<T>) EMPTY;
    }

    @Override
    public boolean isSucceeded() {
        return true;
    }

    @Override
    public T getOrDefault(T other) {
        if (data != null)
            return data;
        else return other;
    }

    @Override
    public T getOrNull() {
        return data;
    }

    @Override
    public Result<T> onSuccess(Completion<T> completion) {
        completion.handle(data);
        return this;
    }

    @Override
    public Result<T> onFailure(Completion<Throwable> completion) {
        return this;
    }

    @Override
    public void onComplete(Runnable action) {
        action.run();
    }

    @Override
    public String toString() {
        return "Success[data=" + data + "]";
    }
}
