package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.domain.CoreConstants;

public class InAppMessageModel implements IApiModel {
    private IDataModel commonModel;
    private String checksum;

    public InAppMessageModel(
            IDataModel commonModel,
            String checksum
    ) {
        this.commonModel = commonModel;
        this.checksum = checksum;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();

        JSONObject checksumJsonObject = new JSONObject();
        checksumJsonObject.put("checksum", checksum);

        root.put("common", commonModel.getJson());
        root.put("in_app_message", checksumJsonObject);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.inAppMessageUrlTemplate;
    }
}
