package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.CoreConstants;

public class ActionHistoryDeleteModel implements IApiModel {
    private final ActionHistoryIdType actionHistoryDeleteType;
    private final String appKey;
    private final String id;
    @Nullable
    private final String historyId;
    private final long timestamp;
    private final CommonModel commonModel;

    public ActionHistoryDeleteModel(
            ActionHistoryIdType actionHistoryDeleteType,
            String appKey,
            String id,
            @Nullable
            String historyId,
            long timestamp,
            CommonModel commonModel
    ) {
        this.actionHistoryDeleteType = actionHistoryDeleteType;
        this.appKey = appKey;
        this.id = id;
        this.historyId = historyId;
        this.timestamp = timestamp;
        this.commonModel = commonModel;
    }

    @Override
    public String getUrlString() {
        StringBuilder urlBuilder = new StringBuilder();

        if (actionHistoryDeleteType == ActionHistoryIdType.ADID) {
            urlBuilder.append(String.format(CoreConstants.actionHistoryDeleteByADIDUrl, appKey, id));
        } else if (actionHistoryDeleteType == ActionHistoryIdType.USER_ID) {
            urlBuilder.append(String.format(CoreConstants.actionHistoryDeleteByUserIDUrl, appKey, id));
        }

        if (historyId != null) {
            urlBuilder.append("/")
                    .append(historyId)
                    .append("/")
                    .append(timestamp);
        }

        return urlBuilder.toString();
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("common", commonModel.getJson());
        return jsonObject;
    }
}
