package io.adbrix.sdk.domain;

import java.util.Arrays;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;

public class CoreConstants {

    public static final int EVENT_BUFFER_COUNT = 10;
    // 60 seconds timeout
    public static final int NETWORK_TIMEOUT = 60_000;
    public static final int SESSION_TIMEOUT = 60_000;
    public static final int BATCHING_INTERVAL = 60_000;
    public static final long PROVIDER_INITIALIZATION_TIMEOUT_MILLISECONDS = 5000;
    public static final String ABX_DATE_FORMAT_SIMPLE = "yyyyMMdd";
    public static final String DB_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String IAM_START_AND_END_DATE_FORMAT_NO_MILLIS = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String IAM_START_AND_END_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String IAM_LAST_UPDATE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    public static final String GROUP_ABX = "abx";
    public static final String GROUP_CUSTOM = "custom";
    public static final String EVENT_START_SESSION = "start_session";
    public static final String EVENT_END_SESSION = "end_session";
    public static final String EVENT_FIRSTOPEN = "firstopen";
    public static final String EVENT_DAILY_FIRSTOPEN = "daily_first_open";
    public static final String EVENT_DEEPLINK_OPEN = "deeplink_open";
    public static final String EVENT_SET_PUSH = "set_push";
    public static final String EVENT_OPEN_PUSH = "open_push";
    public static final String EVENT_IN_APP_MESSAGE = "in_app_message_action";
    public static final String EVENT_ADID_CHANGED = "adid_changed";
    public static final String EVENT_USER_PROPERTY_CHANGED = "user_property_changed";
    public static final List<String> ABX_USER_PROPERTY_KEY_LIST = Arrays.asList("age", "gender", "user_id", "user_id_hash");
    public static final List<String> ABX_CI_KEY_LIST = Arrays.asList("kakao_id"); //, "phone_number");
    public static final String DEEPLINK_PAYLOAD = "abx:deeplink_payload";
    public static final String DEEPLINK_ABX_ADKEY = "abx:deeplink_adkey"; // abx_tid
    public static final String DEEPLINK_ABX_TID = "abx_tid";
    public static final String DEEPLINK_ABX_TRACKER_ID_QUERY_KEY = "abx_tracker_id";
    public static final String DEEPLINK_ABX_TRACKER_ID_PARAM_KEY = "abx:abx_tracker_id";
    public static final String DEEPLINK_LIVE_URL_LEGACY = ".adtouch.adbrix.io";
    public static final String DEEPLINK_STAGE_URL_LEGACY = ".adtouch-stage.adbrix.io";
    public static final String DEEPLINK_DEV_URL_LEGACY = ".adtouch-qa.adbrix.io";
    public static final String DEEPLINK_LIVE_URL_TOKYO = ".ap2.adtouch.dfinery.io";
    public static final String DEEPLINK_STAGE_URL_TOKYO = ".ap2.adtouch-stage.dfinery.io";
    public static final String DEEPLINK_DEV_URL_TOKYO = ".ap2.adtouch-qa.dfinery.io";
    public static final String DEEPLINK_LIVE_URL_SEOUL = ".ap1.adtouch.dfinery.io";
    public static final String DEEPLINK_STAGE_URL_SEOUL = ".ap1.adtouch-stage.dfinery.io";
    public static final String DEEPLINK_DEV_URL_SEOUL = ".ap1.adtouch-qa.dfinery.io";
    public static final String IS_USED_APPLINK_KEY = "is_used_abx_applink";
    public static final String SPECIAL_KEY = "SPECIAL_KEY";
    public static final String COMMERCE_KEY = "COMMERCE_KEY";
    public static final String PAGE_ABX_KEY = "abx:page";
    public static final String PREV_GAID_KEY = "prev_gaid";
    public static final String CURR_GAID_KEY = "curr_gaid";

    public static final String IN_APP_MESSAGE_EVENT_TYPE_ABX_KEY = "abx:gf:event_type";
    public static final String IN_APP_MESSAGE_ACTION_ID_ABX_KEY = "abx:gf:action_id";
    public static final String IN_APP_MESSAGE_IS_IMAGE_DOWNLOADED_ABX_KEY = "abx:gf:is_image_downloaded";
    public static final String IN_APP_MESSAGE_IMAGE_URL_ABX_KEY = "abx:gf:image_url";
    public static final String IN_APP_MESSAGE_IMAGE_SIZE_ABX_KEY = "abx:gf:image_size";
    public static final String IN_APP_MESSAGE_CAMPAIGN_ID_KEY = "abx:gf:campaign_id";
    public static final int MAX_STRING_LENGTH = 1024;
    public static final int MAX_PROPERTY_KEYS = 100;
    public static final int MAX_PRODUCT_NUMBER = 50;
    public static final int MAX_EVENT_COUNT = 1000;
    public static final int USER_PROPERTY_MAX_KEY_LENGTH = 50;
    public static final String CI_KEY = "abxwalterci_";
    public static final String EVENT_ORDER_NO = "abx:event_order_no";
    public static final String SESSION_ORDER_NO = "abx:session_order_no";
    public static final String DATA_REGISTRY_ARCHIVING_KEY = "abx_data_registry_v1";

    public static final String ACTION_HISTORY_ACTION_TYPE_PUSH_ANDROID = "PUSH_ANDROID";
    public static final String ACTION_HISTORY_RESPONSE_HISTORIES = "histories";
    public static final String ACTION_HISTORY_RESPONSE_HISTORY_ID = "id";
    public static final String ACTION_HISTORY_RESPONSE_ACTION_TYPE = "type";
    public static final String ACTION_HISTORY_RESPONSE_CONTENTS = "contents";
    public static final String ACTION_HISTORY_RESPONSE_TIMESTAMP = "timestamp";
    public static final String ACTION_HISTORY_RESPONSE_CAMPAIGN_ID = "campaign_id";
    public static final String ACTION_HISTORY_RESPONSE_CAMPAIGN_REVISION_NO = "campaign_revision_no";
    public static final String ACTION_HISTORY_RESPONSE_STEP_ID = "step_id";
    public static final String ACTION_HISTORY_RESPONSE_CYCLE_TIME = "cycle_time";
    public static final String ACTION_HISTORY_RESPONSE_GROUP = "action_group";
    public static final String ACTION_HISTORY_RESPONSE_IS_READ = "is_read";

    public static final String CONFIG_REQUEST_URL_ADBRIX = "https://static.adbrix.io/sdk.config/%s/config.json";
    public static final int LIVE_MODE = 0;
    public static final int DEV_MODE = 1;
    public static final int STAGE_MODE = 2;
    public static final String SERVER_MODE_KEY = "AdbrixServerMode";
    public static final String SERVER_REGION_KEY = "DfnRegion";
    public static final String SERVER_REGION_SEOUL = "ap1";
    public static final String SERVER_REGION_TOKYO = "ap2";

    public static final String ABX_ENDPOINT_LIVE = "https://ap2.event.dfinery.io";
    public static final String ABX_ENDPOINT_STAGE = "https://ap2.event-stage.dfinery.io";
    public static final String ABX_ENDPOINT_DEV = "https://ap2.event-qa.dfinery.io";

    public static final String ABX_ENDPOINT_LIVE_SEOUL = "https://ap1.event.dfinery.io";
    public static final String ABX_ENDPOINT_STAGE_SEOUL = "https://ap1.event-stage.dfinery.io";
    public static final String ABX_ENDPOINT_DEV_SEOUL = "https://ap1.event-qa.dfinery.io";

    public static final String GDPR_ENDPOINT_PROD = "https://gdpr.adbrix.io";
    public static final String GDPR_ENDPOINT_DEV = "https://gdpr-qa.adbrix.io";
    public static final String GDPR_ENDPOINT_PROD_SEOUL = "https://gdpr.dfinery.io";
    public static final String GDPR_ENDPOINT_DEV_SEOUL = "https://gdpr-qa.dfinery.io";

    public static final String CONFIG_REQUEST_PROD_URL = "https://static.adbrix.io/prod/sdk.config/%s/config.json";
    public static final String CONFIG_REQUEST_DEV_URL = "https://static.adbrix.io/dev/sdk.config/%s/config.json";

    public static String configRequestUrl = CONFIG_REQUEST_PROD_URL;

    public static final String IN_APP_MESSAGE_URL_TEMPLATE_DEV = "http://iam-api-dev.gf.adbrix.io/api/v1/inappmessage/campaigns/get";
    public static final String IN_APP_MESSAGE_URL_TEMPLATE_PROD = "https://iam-api.gf.adbrix.io/api/v1/inappmessage/campaigns/get";
    public static final String IN_APP_MESSAGE_URL_TEMPLATE_DEV_SEOUL = "http://iam-api-dev.ap1.gf.dfinery.io/api/v1/inappmessage/campaigns/get";
    public static final String IN_APP_MESSAGE_URL_TEMPLATE_PROD_SEOUL = "https://iam-api.ap1.gf.dfinery.io/api/v1/inappmessage/campaigns/get";
    public static String inAppMessageUrlTemplate = IN_APP_MESSAGE_URL_TEMPLATE_PROD;

    public static final String ACTION_HISTORY_ENDPOINT_DEV = "https://web-api-dev.ap2.gf.dfinery.io";
    public static final String ACTION_HISTORY_ENDPOINT_PROD = "https://web-api.ap2.gf.dfinery.io";
    public static final String ACTION_HISTORY_ENDPOINT_DEV_SEOUL = "https://web-api-dev.ap1.gf.dfinery.io";
    public static final String ACTION_HISTORY_ENDPOINT_PROD_SEOUL = "https://web-api.ap1.gf.dfinery.io";

    public static String abxEndpoint = ABX_ENDPOINT_LIVE;
    public static String deferredDeeplinkUrlReq = abxEndpoint + "/api/v6/deferred-deeplink/%s";
    public static String bulkEventTrackingUrlTemplate = abxEndpoint + "/api/v6/event/bulk/%s";
    public static String singleEventTrackingUrlTemplate = abxEndpoint + "/api/v4/event/single/%s";
    public static String drworksUrl = abxEndpoint + "/api/v6/drworks/%s";
    public static String abxGdprEndpoint = GDPR_ENDPOINT_PROD;
    public static String gdprUrlReq = abxGdprEndpoint + "/api/opengdpr_requests";
    public static String actionHistoryEndpoint = ACTION_HISTORY_ENDPOINT_PROD;
    public static String actionHistoryQueryUrl = actionHistoryEndpoint + "/api/v6/ActionHistory/List";
    public static String actionHistoryDeleteByADIDUrl = actionHistoryEndpoint + "/api/v6/actionhistory/%s/device/%s";
    public static String actionHistoryDeleteByUserIDUrl = actionHistoryEndpoint + "/api/v6/actionhistory/%s/user/%s";

    private CoreConstants() {
    }

//    private static final String APP_SCANNING_PROD_URL = "https://stream.adbrix.io/api/v4/record/put/abxas/%s";
//    private static final String APP_SCANNING_DEV_URL = "https://stream-dev.adbrix.io/api/v4/record/put/abxas/%s";
//    public static String APP_SCAN_URL = APP_SCANNING_DEV_URL;

    public static void setServerMode(int serverMode, String region) {
        boolean isSeoulRegion = isSeoulRegion(region);

        if (serverMode == DEV_MODE) {
            abxEndpoint = isSeoulRegion ? ABX_ENDPOINT_DEV_SEOUL : ABX_ENDPOINT_DEV;
            inAppMessageUrlTemplate = isSeoulRegion ? IN_APP_MESSAGE_URL_TEMPLATE_DEV_SEOUL : IN_APP_MESSAGE_URL_TEMPLATE_DEV;
            abxGdprEndpoint = isSeoulRegion ? GDPR_ENDPOINT_DEV_SEOUL : GDPR_ENDPOINT_DEV;
            actionHistoryEndpoint = isSeoulRegion ? ACTION_HISTORY_ENDPOINT_DEV_SEOUL : ACTION_HISTORY_ENDPOINT_DEV;

            configRequestUrl = CONFIG_REQUEST_DEV_URL;

            AbxLog.d("END POINT is changed from ABX_LIVE_SERVER to ABX_DEV_SERVER" + (isSeoulRegion ? "_SEOUL" : ""), true);
        } else if (serverMode == STAGE_MODE) {
            abxEndpoint = isSeoulRegion ? ABX_ENDPOINT_STAGE_SEOUL : ABX_ENDPOINT_STAGE;
            inAppMessageUrlTemplate = isSeoulRegion ? IN_APP_MESSAGE_URL_TEMPLATE_PROD_SEOUL : IN_APP_MESSAGE_URL_TEMPLATE_PROD;
            abxGdprEndpoint = isSeoulRegion ? GDPR_ENDPOINT_PROD_SEOUL : GDPR_ENDPOINT_PROD;
            actionHistoryEndpoint = isSeoulRegion ? ACTION_HISTORY_ENDPOINT_PROD_SEOUL : ACTION_HISTORY_ENDPOINT_PROD;

            configRequestUrl = CONFIG_REQUEST_PROD_URL;

            AbxLog.d("END POINT is changed from ABX_LIVE_SERVER to ABX_STAGE_SERVER" + (isSeoulRegion ? "_SEOUL" : ""), true);
        } else {
            abxEndpoint = isSeoulRegion ? ABX_ENDPOINT_LIVE_SEOUL : ABX_ENDPOINT_LIVE;
            inAppMessageUrlTemplate = isSeoulRegion ? IN_APP_MESSAGE_URL_TEMPLATE_PROD_SEOUL : IN_APP_MESSAGE_URL_TEMPLATE_PROD;
            abxGdprEndpoint = isSeoulRegion ? GDPR_ENDPOINT_PROD_SEOUL : GDPR_ENDPOINT_PROD;
            actionHistoryEndpoint = isSeoulRegion ? ACTION_HISTORY_ENDPOINT_PROD_SEOUL : ACTION_HISTORY_ENDPOINT_PROD;

            configRequestUrl = CONFIG_REQUEST_PROD_URL;

            if (isSeoulRegion)
                AbxLog.d("END POINT is changed from ABX_LIVE_SERVER to ABX_LIVE_SERVER_SEOUL", true);
        }

        gdprUrlReq = abxGdprEndpoint + "/api/opengdpr_requests";
        bulkEventTrackingUrlTemplate = abxEndpoint + "/api/v6/event/bulk/%s";
        deferredDeeplinkUrlReq = abxEndpoint + "/api/v6/deferred-deeplink/%s";
        drworksUrl = abxEndpoint + "/api/v6/drworks/%s";
        actionHistoryQueryUrl = actionHistoryEndpoint + "/api/v6/ActionHistory/List";
        actionHistoryDeleteByADIDUrl = actionHistoryEndpoint + "/api/v6/actionhistory/%s/device/%s";
        actionHistoryDeleteByUserIDUrl = actionHistoryEndpoint + "/api/v6/actionhistory/%s/user/%s";
    }

    private static boolean isSeoulRegion(String region) {
        return SERVER_REGION_SEOUL.equals(region);
    }
}
