package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.DeferredDeeplinkModel;

public class DeferredDeeplinkModelProvider implements IApiModelProvider<DeferredDeeplinkModel> {
    private DataRegistry dataRegistry;

    public DeferredDeeplinkModelProvider(DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
    }

    @Override
    public DeferredDeeplinkModel provide() {
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);

        return new DeferredDeeplinkModel(
                "and",
                adid,
                appKey
        );
    }
}
