package io.adbrix.sdk.data.inAppMessage;

import android.graphics.Bitmap;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;

import io.adbrix.sdk.component.AbxLog;

public class InAppMessage {
    private final String campaignId;
    private final String type;
    private final String layout;
    private final String bgColor;
    private final String overlayColor;
    private final String titleText;
    private final String titleTextColor;
    private final String bodyText;
    private final String bodyTextColor;
    private final String textAlign;
    private final String defaultCloseButtonColor;
    private final String defaultCloseButtonBgColor;
    private final JSONObject stickyBannerClickOption;
    private final int numberOfButtons;
    private final JSONArray buttonArray;
    private final String blackColor = "#000000";
    private final String whiteColor = "#FFFFFF";
    //private final String html;
    private Bitmap portraitImage;
    private String portraitImageURL;
    private Boolean isPortraitImageDownloaded;
    private Bitmap landscapeImage;
    private String landscapeImageURL;
    private Boolean isLandscapeImageDownloaded;
    private JSONObject imageClickAction;

    public InAppMessage(
            String campaignId,
            String type,
            String layout,
            Bitmap portraitImage,
            String portraitURL,
            Boolean isPortraitImageDownloaded,
            Bitmap landscapeImage,
            String landscapeURL,
            Boolean isLandscapeImageDownloaded,
            String imageClickAction,
            String bgColor,
            String overlayColor,
            String text,
            String buttonArray,
            String defaultCloseButtonColor,
            String defaultCloseButtonBgColor,
            String stickyBannerClickOption
    ) {
        String nullString = "null";
        String defaultOverlayColor = "#EEEEEEEE";

        this.campaignId = campaignId;
        this.type = type;
        this.layout = layout;
        //this.html = html;
        this.portraitImage = portraitImage;
        this.portraitImageURL = portraitURL;
        this.isPortraitImageDownloaded = isPortraitImageDownloaded;
        this.landscapeImage = landscapeImage;
        this.landscapeImageURL = landscapeURL;
        this.isLandscapeImageDownloaded = isLandscapeImageDownloaded;
        this.bgColor = nullString.equals(bgColor) ? whiteColor : bgColor;
        this.overlayColor = nullString.equals(overlayColor) ? defaultOverlayColor : overlayColor;
        this.defaultCloseButtonColor = defaultCloseButtonColor == null || nullString.equals(defaultCloseButtonColor) ? whiteColor : defaultCloseButtonColor;
        this.defaultCloseButtonBgColor = defaultCloseButtonBgColor == null || nullString.equals(defaultCloseButtonBgColor) ? blackColor : defaultCloseButtonBgColor;

        int tempNumberOfButtons;
        JSONArray tempButtonArray;
        JSONObject tempStickyBannerClickOption;
        JSONObject textJsonObject;
        String tempTitleText = "";
        String tempTitleTextColor = blackColor;
        String tempBodyText = "";
        String tempBodyTextColor = blackColor;
        String tempTextAlign = IInAppMessageViewFactory.TextAlign.CENTER.getValue();
        JSONObject imageClickActionJsonObject;

        try {
            if (stickyBannerClickOption != null) {
                tempStickyBannerClickOption = new JSONObject(stickyBannerClickOption);
            } else {
                tempStickyBannerClickOption = null;
            }

            if (buttonArray != null) {
                tempButtonArray = new JSONArray(buttonArray);
            } else {
                tempButtonArray = null;
            }

            if (tempButtonArray == null) {
                tempNumberOfButtons = 0;
            } else {
                tempNumberOfButtons = tempButtonArray.length();
            }

            if (text == null) {
                textJsonObject = null;
            } else {
                textJsonObject = new JSONObject(text);
            }

            if (text != null) {
                tempTitleText = textJsonObject.getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_TEXT_TITLE);
                tempTitleTextColor = textJsonObject.getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_TEXT_TITLE_COLOR);
                tempBodyText = textJsonObject.getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_TEXT_BODY);
                tempBodyTextColor = textJsonObject.getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_TEXT_BODY_COLOR);
                tempTextAlign = textJsonObject.getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_TEXT_ALIGN);
            }

            if (imageClickAction == null) {
                imageClickActionJsonObject = null;
            } else {
                imageClickActionJsonObject = new JSONObject(imageClickAction);
            }
        } catch (JSONException e) {
            AbxLog.e("JsonError while construct inAppMessage" + Arrays.toString(e.getStackTrace()), true);
            tempButtonArray = new JSONArray();
            tempNumberOfButtons = 0;
            tempStickyBannerClickOption = new JSONObject();
            imageClickActionJsonObject = new JSONObject();
        }

        this.buttonArray = tempButtonArray;
        this.numberOfButtons = tempNumberOfButtons;
        this.stickyBannerClickOption = tempStickyBannerClickOption;
        this.titleText = tempTitleText;
        this.titleTextColor = tempTitleTextColor;
        this.bodyText = tempBodyText;
        this.bodyTextColor = tempBodyTextColor;
        this.textAlign = tempTextAlign;
        this.imageClickAction = imageClickActionJsonObject;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public String getType() {
        return type;
    }

    public String getLayout() {
        return layout;
    }

    public String getHtml() {
        //return html;
        return null;
    }

    public Bitmap getPortraitImage() {
        return portraitImage;
    }

    public void setPortraitImage(Bitmap portraitImage) {
        this.portraitImage = portraitImage;
    }

    public String getPortraitImageURL() {
        return portraitImageURL;
    }

    public void setPortraitImageURL(String portraitImageURL) {
        this.portraitImageURL = portraitImageURL;
    }

    public boolean getsIsPortraitImageDownloaded() {
        return isPortraitImageDownloaded == null ? false : isPortraitImageDownloaded;
    }

    public Bitmap getLandScapeImage() {
        return landscapeImage;
    }

    public String getLandscapeImageURL() {
        return landscapeImageURL;
    }

    public void setLandscapeImageURL(String landscapeImageURL) {
        this.landscapeImageURL = landscapeImageURL;
    }

    public boolean getsIsLandscapeImageDownloaded() {
        return isLandscapeImageDownloaded == null ? false : isLandscapeImageDownloaded;
    }

    public String getImageClickActionId() {
        try {
            return imageClickAction.optString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_ID);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getImageClickActionType() {
        try {
            return imageClickAction.optString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_TYPE);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getImageClickActionArg() {
        try {
            return imageClickAction.optString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_IMAGE_CLICK_ACTION_ACTION_ARG);
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getTitleText() {
        return titleText;
    }

    public String getTitleTextColor() {
        return titleTextColor;
    }

    public String getBodyText() {
        return bodyText;
    }

    public String getBodyTextColor() {
        return bodyTextColor;
    }

    public String getTextAlign() {
        return textAlign;
    }

    public String getBgColor() {
        return bgColor;
    }

    public String getOverlayColor() {
        return overlayColor;
    }

    public int getNumberOfButtons() {
        return numberOfButtons;
    }

    public String getButtonId(int index) {
        try {
            return buttonArray.getJSONObject(index).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_BUTTON_ID);
        } catch (JSONException jsonException) {
            jsonException.printStackTrace();
        } catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }

        return null;
    }

    public String getButtonText(int index) {
        try {
            return buttonArray.getJSONObject(index).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_TEXT);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getButtonActionID(int index) {
        try {
            return buttonArray.getJSONObject(index).getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ID);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getButtonActionType(int index) {
        try {
            return buttonArray.getJSONObject(index).getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ACTION_TYPE);
        } catch (JSONException e) {
            return null;
        }
    }

    public String getButtonActionArgument(int index) {
        try {
            return buttonArray.getJSONObject(index).getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_CLICK_ACTION_ACTION_ARG);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getButtonTextColor(int index) {
        try {
            return buttonArray.getJSONObject(index).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_TEXT_COLOR);
        } catch (JSONException jsonException) {
            return blackColor;
        } catch (NullPointerException nullPointerException) {
            return blackColor;
        }
    }

    public String getButtonBackgroundColor(int index) {
        try {
            return buttonArray.getJSONObject(index).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_BG_COLOR);
        } catch (JSONException jsonException) {
            return whiteColor;
        } catch (NullPointerException nullPointerException) {
            return whiteColor;
        }
    }

    public String getButtonBoarderColor(int index) {
        try {
            return buttonArray.getJSONObject(index).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_BUTTONS_BORDER_COLOR);
        } catch (JSONException e) {
            return blackColor;
        } catch (NullPointerException nullPointerException) {
            return blackColor;
        }
    }

    public String getDefaultCloseButtonColor() {
        return defaultCloseButtonColor;
    }

    public String getDefaultCloseButtonBgColor() {
        return defaultCloseButtonBgColor;
    }

    public String getStickyBannerAlign() {
        return stickyBannerClickOption.optString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_ALIGN);
    }

    public String getStickBannerClickActionActionID() {
        try {
            return this.stickyBannerClickOption.getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_ID);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getStickBannerClickActionActionType() {
        try {
            return this.stickyBannerClickOption.getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_TYPE);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getStickBannerClickOptionActionArg() {
        try {
            return this.stickyBannerClickOption.getJSONObject(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION).getString(InAppMessageDAO.RESPONSE_IAM_CONTENTS_STICKY_BANNER_OPTION_CLICK_ACTION_ACTION_ARG);
        } catch (JSONException jsonException) {
            return null;
        } catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void setIsPortraitImageDownloaded(Boolean isPortraitImageDownloaded) {
        this.isPortraitImageDownloaded = isPortraitImageDownloaded;
    }

    public void setLandscapeImage(Bitmap landscapeImage) {
        this.landscapeImage = landscapeImage;
    }

    public void setIsLandscapeImageDownloaded(Boolean isLandscapeImageDownloaded) {
        this.isLandscapeImageDownloaded = isLandscapeImageDownloaded;
    }

    public void setImageClickAction(String imageClickAction) {
        try {
            this.imageClickAction = new JSONObject(imageClickAction);
        } catch (JSONException jsonException) {
            this.imageClickAction = null;
        }
    }

}
