package io.adbrix.sdk.data;

import java.util.concurrent.atomic.AtomicBoolean;

public class ABXBooleanState {
    public AtomicBoolean adbrixError = new AtomicBoolean();
    public AtomicBoolean inForeground = new AtomicBoolean(false);
    public AtomicBoolean isDebugAppInstalled = new AtomicBoolean(false);
    public AtomicBoolean isSessionStarted = new AtomicBoolean(false);
    public AtomicBoolean isInAppMessagePresented = new AtomicBoolean(false);

    private ABXBooleanState() {
    }

    public static ABXBooleanState getInstance() {
        return Singleton.INSTANCE;
    }

    public boolean isAdbrixError() {
        return adbrixError.get();
    }

    public boolean inForeground() {
        return inForeground.get();
    }

    public boolean isDebugAppInstalled() {
        return isDebugAppInstalled.get();
    }

    public boolean isSessionStarted() {
        return isSessionStarted.get();
    }

    public boolean isInAppMessagePresented() {
        return isInAppMessagePresented.get();
    }

    private static class Singleton {
        private static final ABXBooleanState INSTANCE = new ABXBooleanState();
    }
}
