package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.interactor.DeleteUserDataUseCase;
import io.adbrix.sdk.domain.interactor.RestartSDKUseCase;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Error;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public class DisabledABXContext implements IABXContext {

    private static final String WARNING_FOR_DISABLED_CONTEXT = "Disabled된 ABX SDK의 Method가 호출되었습니다.";
    private final Repository repository;

    public DisabledABXContext(String disabledReason, Repository repository) {
        AbxLog.d("ABX SDK가 Disabled 되었습니다. 이유는 = " + disabledReason, true);
        this.repository = repository;
    }

    @Override
    public Result<String> initialize(Context context, String appkey, String secretkey) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
        return Error.of(WARNING_FOR_DISABLED_CONTEXT);
    }

    @Override
    public void saveUserProperty(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
        return null;
    }

    @Override
    public void logEvent(LogEventParameter logEventParameter) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void logSameEventWithPaging(String eventName, List<JSONObject> eventParamList) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void runOnIdleTime() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onResume(Activity activity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onPause() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deeplink(Activity deeplinkActivity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deeplinkWithIntent(Intent deeplinkIntent) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void putDataRegistry(DataUnit dataUnit) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public Result<Empty> deleteUserData(String userId) {
        AbxLog.d("Delete user data api called!", true);

        return new DeleteUserDataUseCase(repository, userId).execute();
    }

    @Override
    public Result<Empty> restartSDK(String userId) {
        AbxLog.d("Restart SDK api called!", true);

        return new RestartSDKUseCase(repository, userId).execute();
    }

    @Override
    public void fetchActionHistoryFromServer(@Nullable String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void insertPushData(String pushDataString) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deleteActionHistory(@Nullable String token, String historyId, long timestamp, Completion<Result<Empty>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deleteAllActionHistory(@Nullable String token, @Nullable ActionHistoryIdType idType, Completion<Result<Empty>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion) {
        completion.handle(Error.of(WARNING_FOR_DISABLED_CONTEXT));
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void clearAllActionHistoryInLocalDB() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }
}
