package io.adbrix.sdk.component.autoEvent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObservable;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.ITimerManager;
import io.adbrix.sdk.component.TimerManager;
import io.adbrix.sdk.data.ABXBooleanState;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.interactor.SyncApplicationConfigureUseCase;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class DailyFirstOpenAutoEventGenerator implements ITimerManager, IObservable<LogEventParameter> {
    private String abxDailyFirstOpenDateTime = null;
    private Boolean sendDailyFirstOpenEvent;
    private DataRegistry dataRegistry;
    private Repository repository;
    private Timer timer;
    private List<IObserver<LogEventParameter>> observers;

    public DailyFirstOpenAutoEventGenerator(DataRegistry dataRegistry, Repository repository) {
        this.dataRegistry = dataRegistry;
        this.repository = repository;
        observers = new ArrayList<>();
        TimerManager.getInstance().add(this);
    }

    @Override
    public void add(IObserver<LogEventParameter> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<LogEventParameter> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(LogEventParameter logEventParameter) {
        for (IObserver<LogEventParameter> observer : observers) {
            observer.update(logEventParameter);
        }
    }

    public void process() {
        if (timer == null) {
            timer = new Timer();
        } else return;

        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                doTask();
            }
        }, 60_000, 60_000);
    }

    private void doTask() {

        if (CoreUtils.isAdbrixAllStop(dataRegistry) || ABXBooleanState.getInstance().isAdbrixError()) {
            return;
        }
        try {

            abxDailyFirstOpenDateTime = dataRegistry.safeGetString(DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE, null);

            String tempNowDate = CoreUtils.getDateViaGMTDateFormat(CoreConstants.ABX_DATE_FORMAT_SIMPLE);
            String tempPrevDate = abxDailyFirstOpenDateTime;
            if (sendDailyFirstOpenEvent == null) {
                if (dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT, null) == null) {
                    sendDailyFirstOpenEvent = false;
                } else {
                    sendDailyFirstOpenEvent = Boolean.valueOf(dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT, null));
                }
            }
            // at the first time ( i.e. First Open )
            if (CommonUtils.isNullOrEmpty(tempPrevDate)) {
                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                abxDailyFirstOpenDateTime = tempNowDate;
                tempPrevDate = tempNowDate;
            }

            AbxLog.i("Daily First Open... " + "NOW : " + tempNowDate + " , PREV : " + tempPrevDate, true);

            if (!tempPrevDate.equals(tempNowDate)) {

                clearNotificationStore();

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                sendDailyFirstOpenEvent = true;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                new SyncApplicationConfigureUseCase(repository).execute();
            }
            if (ABXBooleanState.getInstance().inForeground() && sendDailyFirstOpenEvent) {
                sendDailyFirstOpenEvent = false;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                if (!CoreUtils.isAdbrixPause(dataRegistry)) {
                    LogEventParameter eventParameter = new LogEventParameter(
                            CoreConstants.GROUP_ABX,
                            CoreConstants.EVENT_DAILY_FIRSTOPEN,
                            null,
                            0,
                            0);

                    notifyObserver(eventParameter);
                }
            }
            abxDailyFirstOpenDateTime = tempNowDate;

            //InAppMessage
            int minutesToExpiry = dataRegistry.safeGetInt(DataRegistryKey.INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY, -1);
            long inAppMessageLastResponseTime = dataRegistry.safeGetLong(DataRegistryKey.LONG_IN_APP_MESSAGE_LAST_RESPONSE_TIME, -1);

            if (minutesToExpiry == -1 || inAppMessageLastResponseTime == -1 //first inAppMessage request
                    || inAppMessageLastResponseTime + minutesToExpiry * 60 * 1000 < System.currentTimeMillis() //cache expired
            ) {
                repository.connectToInAppMessageApi();
            }
            //InAppMessage end

        } catch (Exception e) {
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }
    }

    private void clearNotificationStore() {
        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_ABX_NOTIFICATION_ID,
                "",
                5,
                this.getClass().getName(),
                true));
    }

    @Override
    public void setTimerToNull() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }
}
