package io.adbrix.sdk.component;

public class TryOptional<T, E extends Exception> {
    private final ThrowingSupplier<T, E> supplier;

    private TryOptional(ThrowingSupplier<T, E> supplier) {
        this.supplier = supplier;
    }

    public static <T, E extends Exception> Optional<T> of(ThrowingSupplier<T, E> supplier) {
        return new TryOptional<T, E>(supplier).get();
    }

    private Optional<T> get() {
        try {
            return Optional.of(supplier.get());
        } catch (Exception e) {
            return Optional.empty();
        }
    }
}
