package io.adbrix.sdk.component;

import java.util.ArrayList;
import java.util.List;

public class TimerManager implements ITimerManager {

    private List<ITimerManager> timerManagers;

    private TimerManager() {
        this.timerManagers = new ArrayList<>();
    }

    public static TimerManager getInstance() {
        return Singleton.INSTANCE;
    }

    public void add(ITimerManager timerManager) {
        timerManagers.add(timerManager);
    }

    @Override
    public void setTimerToNull() {
        for (ITimerManager timerManager: timerManagers) {
            if (timerManager != null)
                timerManager.setTimerToNull();
        }
    }

    private static class Singleton {
        private static final TimerManager INSTANCE = new TimerManager();
    }
}
