package io.adbrix.sdk.component;

public class Lazy<T> implements ThrowingSupplier<T, IABXComponentsFactory.ComponentsCanNotCreateException> {

    private ThrowingSupplier<? extends T, IABXComponentsFactory.ComponentsCanNotCreateException> supplier;
    private volatile T value;

    private Lazy(ThrowingSupplier<? extends T, IABXComponentsFactory.ComponentsCanNotCreateException> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(ThrowingSupplier<? extends T, IABXComponentsFactory.ComponentsCanNotCreateException> supplier) {
        return new Lazy<>(supplier);
    }

    @Override
    public T get() throws IABXComponentsFactory.ComponentsCanNotCreateException {
        T localReference = value;
        if (localReference == null) {
            synchronized (this) {
                localReference = value;
                if (localReference == null) {
                    localReference = this.supplier.get();
                    this.value = localReference;
                    this.supplier = null;
                }
            }
        }
        return localReference;
    }
}
