package io.adbrix.sdk.component;

import android.content.Context;

import org.json.JSONException;

import java.util.Arrays;

import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.modelprovider.CommonModelProvider;
import io.adbrix.sdk.data.modelprovider.EventBundleModelProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.EventBundleModel;
import io.adbrix.sdk.domain.model.EventPackage;
import io.adbrix.sdk.utils.CoreUtils;

public class DefaultEventSender implements IEventSender {
    private DataRegistry dataRegistry;
    private Context androidContext;
    private DeviceRealtimeDataProvider deviceRealtimeDataProvider;

    public DefaultEventSender(DataRegistry dataRegistry, Context androidContext, DeviceRealtimeDataProvider deviceRealtimeDataProvider) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
    }

    @Override
    public void sendEvent(EventPackage eventPackage, IEventSendActionListener sendActionListener) {
        if (eventPackage == null || eventPackage.eventModels == null) {
            AbxLog.d("Invalid eventPackage!", true);
            return;
        }

        if (!CoreUtils.isOnline(androidContext)) {
            AbxLog.e("Fail to sending event. You are not connected to the network.", true);
            sendActionListener.onFail(eventPackage);
            return;
        }

        if (CoreUtils.isGdprForgetMe(dataRegistry, () -> { })) {
            AbxLog.d("GdprForgetMe is true", true);
            sendActionListener.onFail(eventPackage);
            return;
        }

        CommonModel commonModel = new CommonModelProvider(dataRegistry, androidContext, deviceRealtimeDataProvider).provide();
        EventBundleModel eventBundleModel = new EventBundleModelProvider(commonModel, eventPackage).provide();

        ApiConnection apiConnection;
        ApiConnectionManager manager = new ApiConnectionManager(new ApiConnectionManager.Result() {
            @Override
            public void connectSuccess(String responseString, int responseCode) {
                sendActionListener.onSuccess(eventPackage);
                AbxLog.d("Sending event is complete. responseCode : " + responseCode + ", responseString : " + responseString, true);
            }

            @Override
            public void connectFail(int responseCode) {
                sendActionListener.onFail(eventPackage);
                AbxLog.d("Sending event is failed. responseCode : " + responseCode, true);
            }
        });

        try {
            AbxLog.d(eventBundleModel.getJson().toString(4), true);
            apiConnection = new ApiConnection(dataRegistry, androidContext).post(eventBundleModel);
            manager.execute(apiConnection);

        } catch (JSONException e) {
            AbxLog.e("updateServer >> JSONException: " + e.toString(), true);
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }
    }
}
