package io.adbrix.sdk.component;

import android.content.Context;

import io.adbrix.sdk.component.autoEvent.DailyFirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.dataprovider.DefaultNowaitEventNameProvider;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.RepositoryImpl;
import io.adbrix.sdk.data.repository.datasource.DefaultDataContext;
import io.adbrix.sdk.data.repository.datasource.IDataContext;
import io.adbrix.sdk.domain.Repository;

public class DefaultComponentsFactory implements IABXComponentsFactory {

    private Context androidContext;
    private IABXContext abxContext;
    private Lazy<ILogger> logger;
    private Lazy<IDataContext> dataContext;
    private Lazy<DataRegistry> dataRegistry;
    private Lazy<Repository> repository;

    private Lazy<DeviceRealtimeDataProvider> deviceRealtimeDataProvider;
    private Lazy<DeviceStaticDataProvider> deviceStaticDataProvider;
    private Lazy<UserPropertyManager> userPropertyManager;
    private Lazy<V1MigrationManager> v1MigrationManager;
    private Lazy<IEventSender> eventSender;
    private Lazy<DeeplinkParameterSet> deeplinkParameterSet;
    private Lazy<FirstOpenAutoEventGenerator> firstOpenAutoEventGenerator;
    private Lazy<DeeplinkAutoEventGenerator> deeplinkAutoEventGenerator;
    private Lazy<DailyFirstOpenAutoEventGenerator> dailyFirstOpenAutoEventGenerator;
    private Lazy<SessionAutoEventGenerator> sessionAutoEventGenerator;
    private Lazy<EventBuffer> eventBuffer;
    private Lazy<EventPackageContainer> eventPackageContainer;
    private Lazy<V1DatabaseOpenHelper> v1DatabaseOpenHelper;
    private Lazy<EventSamplingFilter> eventSamplingFilter;

    public DefaultComponentsFactory() {
        this.logger = Lazy.of(() -> new DefaultLogger());
        this.dataContext = Lazy.of(() -> new DefaultDataContext(getAndroidContext()));
        this.dataRegistry = Lazy.of(() -> new DataRegistry(createOrGetDataContext(), createOrGetLogger()));
        this.repository = Lazy.of(() -> new RepositoryImpl(this));
        this.deviceRealtimeDataProvider = Lazy.of(() -> new DeviceRealtimeDataProvider(createOrGetDataRegistry(), getAndroidContext()));
        this.deviceStaticDataProvider = Lazy.of(() -> new DeviceStaticDataProvider(createOrGetDataRegistry(), getAndroidContext()));
        this.eventSender = Lazy.of(() -> new DefaultEventSender(createOrGetDataRegistry(), getAndroidContext(), createOrGetDeviceRealtimeDataProvider()));
        this.firstOpenAutoEventGenerator = Lazy.of(() -> new FirstOpenAutoEventGenerator(createOrGetDataRegistry(), getAndroidContext()));
        this.dailyFirstOpenAutoEventGenerator = Lazy.of(() -> new DailyFirstOpenAutoEventGenerator(createOrGetDataRegistry(), createOrGetRepository()));
        this.v1DatabaseOpenHelper = Lazy.of(() -> V1DatabaseOpenHelper.createInstance(getAndroidContext()));
        this.eventSamplingFilter = Lazy.of(() -> new EventSamplingFilter(createOrGetDataRegistry()));
    }

    @Override
    public Context getAndroidContext() throws ComponentsCanNotCreateException {
        if (this.androidContext == null) {
            throw new ComponentsCanNotCreateException("안드로이드 컨텍스트를 먼저 입력해야 합니다.");
        }

        return this.androidContext;
    }

    @Override
    public void setAndroidContext(Context context) {
        this.androidContext = context;
    }

    @Override
    public UserPropertyManager createOrGetUserPropertyManager() throws ComponentsCanNotCreateException {
        return this.userPropertyManager.get();
    }

    @Override
    public IEventSender createOrGetEventSender() throws ComponentsCanNotCreateException {
        return this.eventSender.get();
    }

    @Override
    public IABXContext getABXContext() throws ComponentsCanNotCreateException {
        if (this.abxContext == null) {
            throw new ComponentsCanNotCreateException("ABXContext를 먼저 입력해야 합니다.");
        }

        return this.abxContext;
    }

    @Override
    public void setABXContext(IABXContext context) {
        this.abxContext = context;
    }

    @Override
    public FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException {
        return this.firstOpenAutoEventGenerator.get();
    }

    @Override
    public SessionAutoEventGenerator createOrGetSessionAutoEventGenerator() throws ComponentsCanNotCreateException {
        return this.sessionAutoEventGenerator.get();
    }

    @Override
    public DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator() throws ComponentsCanNotCreateException {
        return this.deeplinkAutoEventGenerator.get();
    }

    @Override
    public ILogger createOrGetLogger() {
        try {
            return this.logger.get();
        } catch (ComponentsCanNotCreateException e) {
            return new DefaultLogger();
        }
    }

    @Override
    public DataRegistry createOrGetDataRegistry() throws ComponentsCanNotCreateException {
        return this.dataRegistry.get();
    }

    @Override
    public IDataContext createOrGetDataContext() throws ComponentsCanNotCreateException {
        return this.dataContext.get();
    }

    @Override
    public DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider() throws ComponentsCanNotCreateException {
        return this.deviceRealtimeDataProvider.get();
    }

    @Override
    public DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() throws ComponentsCanNotCreateException {
        return this.deviceStaticDataProvider.get();
    }

    @Override
    public V1MigrationManager createOrGetV1MigrationManager() throws ComponentsCanNotCreateException {
        return this.v1MigrationManager.get();
    }

    @Override
    public DeeplinkParameterSet createOrGetDeeplinkParameterSet() throws ComponentsCanNotCreateException {
        return this.deeplinkParameterSet.get();
    }

    @Override
    public Repository createOrGetRepository() throws ComponentsCanNotCreateException {
        return this.repository.get();
    }

    @Override
    public EventBuffer createOrGetEventBuffer() throws ComponentsCanNotCreateException {
        return this.eventBuffer.get();
    }

    @Override
    public EventPackageContainer createOrGetEventPackageContainer() throws ComponentsCanNotCreateException {
        return this.eventPackageContainer.get();
    }

    @Override
    public DailyFirstOpenAutoEventGenerator createOrGetDailyFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException {
        return this.dailyFirstOpenAutoEventGenerator.get();
    }

    @Override
    public V1DatabaseOpenHelper createOrGetV1DatabaseOpenHelper() throws ComponentsCanNotCreateException {
        return this.v1DatabaseOpenHelper.get();
    }

    @Override
    public EventSamplingFilter createOrGetEventSamplingFilter() throws ComponentsCanNotCreateException {
        return this.eventSamplingFilter.get();
    }

    @Override
    public void activate() {
        this.userPropertyManager = Lazy.of(() ->
                new UserPropertyManager(
                        createOrGetDataContext(),
                        createOrGetLogger(),
                        createOrGetDataRegistry()
                )
        );
        this.deeplinkParameterSet = Lazy.of(() ->
                new DeeplinkParameterSet(
                        createOrGetDataRegistry()
                )
        );
        this.sessionAutoEventGenerator = Lazy.of(() ->
                new SessionAutoEventGenerator(
                        createOrGetDataRegistry(),
                        createOrGetFirstOpenAutoEventGenerator(),
                        createOrGetRepository(),
                        createOrGetDeeplinkParameterSet(),
                        createOrGetV1MigrationManager()
                )
        );
        this.deeplinkAutoEventGenerator = Lazy.of(() ->
                new DeeplinkAutoEventGenerator(
                        createOrGetDataRegistry(),
                        createOrGetDeeplinkParameterSet()
                )
        );
        this.v1MigrationManager = Lazy.of(() ->
                new V1MigrationManager(
                        createOrGetDataRegistry(),
                        createOrGetUserPropertyManager(),
                        createOrGetV1DatabaseOpenHelper(),
                        createOrGetEventPackageContainer()
                )
        );
        this.eventPackageContainer = Lazy.of(() ->
                new EventPackageContainer(
                        createOrGetEventSender(),
                        createOrGetDataRegistry()
                )
        );
        this.eventBuffer = Lazy.of(() ->
                new EventBuffer(
                        createOrGetEventPackageContainer(),
                        new DefaultNowaitEventNameProvider()
                )
        );
    }

    @Override
    public void deactivate() {
        TimerManager.getInstance().setTimerToNull();

        this.userPropertyManager = null;
        this.deeplinkParameterSet = null;
        this.sessionAutoEventGenerator = null;
        this.deeplinkAutoEventGenerator = null;
        this.v1MigrationManager = null;
        this.eventPackageContainer = null;
        this.eventBuffer = null;
    }
}
