package io.adbrix.sdk.domain.model;

import io.adbrix.sdk.domain.CoreConstants;

import org.json.JSONException;
import org.json.JSONObject;

public class DeferredDeeplinkModel implements IApiModel{
    private String platform = null;
    private String device_id = null;

    public DeferredDeeplinkModel(
            String platform,
            String device_id
    ){
        this.platform = platform;
        this.device_id = device_id;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();

        root.put("platform", platform);
        root.put("device_id", device_id);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.DEFERRED_DEEPLINK_URL_REQ;
    }
}
