package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class DRModel implements IApiModel {
    private final IdentityModel identityModel;
    private final String userId;
    private final OperationType operationType;
    private final String eventDatetime;
    private final JSONObject req;

    public enum OperationType {
        DELETE("delete"),
        INITIALIZE("initialize"),
        RESTART("restart");

        final String typeValue;

        OperationType(String typeValue) {
            this.typeValue = typeValue;
        }
    }

    public DRModel(IdentityModel identityModel, String userId, OperationType operationType, JSONObject req) {
        this.identityModel = identityModel;
        this.userId = userId;
        this.operationType = operationType;
        this.eventDatetime = CommonUtils.getCurrentUTCInDBFormat();
        this.req = req;
    }

    public DRModel(IdentityModel identityModel, String userId, OperationType operationType, String eventDatetime, JSONObject req) {
        this.identityModel = identityModel;
        this.userId = userId;
        this.operationType = operationType;
        this.eventDatetime = eventDatetime;
        this.req = req;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        JSONObject identityJson = identityModel.getJson();

        identityJson.remove("igaw_id");
        identityJson.remove("ad_id_opt_out");
        identityJson.remove("device_id");
        identityJson.remove("registration_id");
        identityJson.remove("is_push_enable");
        identityJson.remove("is_push_enable_os");

        root.put("identity", identityJson);
        root.put("user_id", userId == null || userId.equals("") ? JSONObject.NULL : userId);
        root.put("type", operationType.typeValue);
        root.put("platform", "and");
        root.put("event_datetime", eventDatetime);
        root.put("req", req);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.DRWORKS_URL;
    }
}
