package io.adbrix.sdk.domain;

import android.app.Activity;

import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface Repository {
    EventModel getEventModel(LogEventParameter logEventParameter);

    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);
    void initDefaultConfigValue();
    void syncApplicationConfigure();
    void gdprForgetMe();
//    void updateFavoriteApplication();
    void registerNetworkCallback();
    void saveUnsentEvents();
    void logEvent(LogEventParameter logEventParameter);
    void flushAllNow();
    void flushAtIntervals();

    //InAppMessage 
    void resetInAppMessageFrequencySession();
    void triggerInAppMessage(String eventName);
    void shutDownInAppMessageExecutor();
    void updateCurrentActivity(Activity activity);
    void deleteCurrentActivity(Activity activity);
    void connectToInAppMessageApi();
    void dismissInAppMessageDialog();

    //DRWorks
    void deleteUserData(String userId, ApiConnectionManager.Result result);
    void restartSDK(String userId, ApiConnectionManager.Result result);
}
