package io.adbrix.sdk.data.net;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.ABXBooleanState;

public class SocketClientManager {
    public interface Result {
        void connectSuccess(int responseCode);
        void connectFail();
    }

    private Result result;

    public SocketClientManager(Result result){
        this.result = result;
    }

    public void Execute(SocketClient client){
        if (ABXBooleanState.getInstance().isAdbrixPause()){
            AbxLog.d("SocketClientManager :: Skip request due to pause state", true);
            return;
        }

        client.run();

        if (client.getResponseCode() == 200 || client.getResponseCode() == 201){
            result.connectSuccess(client.getResponseCode());
        }
        else result.connectFail();
    }
}
