package io.adbrix.sdk.data.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;

import io.adbrix.sdk.component.AbxLog;

public class SocketClient {
    private int responseCode = 0;
    private String ip;
    private String data;
    private int port;

    public SocketClient(String ipAndPort, String data){
        this.ip = getIp(ipAndPort);
        this.port = getPort(ipAndPort);
        this.data = data;
        AbxLog.d("SKB:: Attempting to connect to "+ this.ip + ":" + this.port, true);
    }

    public void run(){
        if(ip == null || port == -1)
            return;

        if (data == null) {
            AbxLog.d("SKB:: Message is invalid. Skip this turn.", true);
            responseCode = 201;
            return;
        }

        try{
            InetAddress ia = InetAddress.getByName(ip);
            DatagramSocket ds = new DatagramSocket();

            byte[] buffer = data.getBytes();
            DatagramPacket dp = new DatagramPacket(
                    buffer,buffer.length,ia, port);
//            ds.setSoTimeout(10_000);
            ds.send(dp);
            responseCode = 200;
            AbxLog.d("SKB:: Client sent " + data + " to the server.", true);
//            buffer = new byte[512];
//            dp = new DatagramPacket(buffer,buffer.length);
//            ds.receive(dp);
//
//            System.out.println("server ip : "+dp.getAddress() + " , server port : "+dp.getPort());
//            System.out.println("서버로부터 수신된 데이터 : "+ new String(dp.getData()).trim());
//            Log.d(ABXConstants.LOGTAG,"server ip : "+dp.getAddress() + " , server port : "+dp.getPort());
//            Log.d(ABXConstants.LOGTAG,"서버로부터 수신된 데이터 : "+ new String(dp.getData()).trim());
//            if (dp.getData() != null)
////                responseCode = 200;
        }catch(IOException ioe){
            AbxLog.w(Arrays.toString(ioe.getStackTrace()),true);
        }
    }

    private String getIp(String ipAndPort){
        if(ipAndPort == null || ipAndPort.length()!=17)
            return null;

        String ip = ipAndPort.substring(0, 12);

        String dottedIp = "";

        for (int i = 0; i < ip.length(); i+=3){
            dottedIp += ip.substring(i, i + 3) + ".";
        }
        dottedIp = dottedIp.substring(0,15);

        return dottedIp;
    }

    private int getPort(String ipAndPort){
        if(ipAndPort == null || ipAndPort.length()!=17)
            return -1;

        String port = ipAndPort.substring(12, 17);

        if (port.charAt(0) == '0'){
            port = port.substring(1, 5);
        }

        return Integer.parseInt(port);
    }

    public int getResponseCode() {
        return responseCode;
    }
}
